PRIMARY_ALERT_TEMPLATE = '''
[
    <% set juggler_without_calls = {
        "flaps": {
            "critical": 60,
            "stable": 30
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_with_calls = {
        "flaps": {
            "critical": 60,
            "stable": 30
        },
        "namespace": "mail.maildev",
        "tags": ["working_time_calls"],
    } %>
    <% set juggler_dict_without_calls = {
        "test": juggler_without_calls,
        "load": juggler_without_calls,
        "prod": juggler_without_calls,
        "corp": juggler_without_calls,
    } %>
    <% set juggler_dict_with_calls = {
        "test": juggler_without_calls,
        "load": juggler_without_calls,
        "prod": juggler_with_calls,
        "corp": juggler_with_calls,
    } %>
    <% set tasks = ["delete_mail_user", "delete_shards_user", "clone_user"] %>
    <% set error_types = ["unknown", "null"] %>
    <% for env in ["test", "load", "prod", "corp"] %>
        <% set q_prj = "mail.husky." ~ env %>
        << Alert(
                name=env ~ ".husky_api.5xx",
                signal="or(perc(unistat-nginx_request_5xx_count_deee, unistat-nginx_request_total_count_deee), 0)",
                tags={
                    "itype": "qloud",
                    "prj": q_prj,
                },
                mgroups=["QLOUD"],
                warn=[1, 5],
                crit=[5, None],
                juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                    "host": q_prj,
                    "service": "husky_api.5xx"
                })
        ) >>,
        <% for task_name in tasks %>
            <% for error_type in error_types %>
                << Alert(
                    name=env ~ "." ~ task_name ~ "." ~ error_type ~ ".errors",
                    signal="or(unistat-db_task_" ~ task_name ~ "_with_error_type_" ~ error_type ~ "_axxv, 0)",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                    },
                    mgroups=["QLOUD"],
                    warn=[None, None],
                    crit=[1, None],
                    juggler_check=juggler_dict_with_calls[env]|merge_with_dict({
                        "host": q_prj,
                        "service": "husky.db_task." ~ task_name ~ "." ~ error_type ~ ".errors"
                    })
                ) >>,
            <% endfor %>
        <% endfor %>
    <% endfor %>
]
'''


def primary_template():
    return 'husky', PRIMARY_ALERT_TEMPLATE
