PRIMARY_PANEL_TEMPLATE = '''
<< suggest.clear() >>
<< suggest.set_choice_list("env", [ "prod", "corp", "load", "test" ]) >>

<% set only_canary = only_canary|default("false") %>
<< suggest.set_choice_list("only_canary", [ "false", "true" ]) >>

<% set host = "QLOUD" %>
<% set service = "husky" %>
<% set data_centers = ['iva', 'myt', 'sas', 'vla', 'man'] %>

<% if only_canary == "true" %>
    <% set tier = ";tier=" ~ service ~ "-canary*" %>
    <% set panel_title = service ~ "-canary (" ~ env ~ ")" %>
<% else %>
    <% set tier = "" %>
    <% set panel_title = service ~ " (" ~ env ~ ")" %>
<% endif %>

<% set main = create_main_layout("vertical") %>
<% set flow = main.sub("flow", columns = 12) %>


{
    "title": "<< panel_title >>",
    "type": "panel",
    "key": "husky_panel",
    "editors": [],
    "charts": [

        <#
        # nginx metrics
        #>
        {
            "type": "text",
            "text": "nginx metrics",
            << flow.coords(width = 12, height = 0.3) >>,
        },
        <% for codes in [ '2xx', '5xx', '4xx' ] %>
            {
                "type": "graphic",
                "title": "nginx <<codes>>, rps",
                << flow.coords(width = 3, height = 1) >>,
                "stacked": true,
                "normalize": true,
                "signals": [
                    <% for geo in data_centers %>
                    {
                        "title": "<< geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >><< tier >>",
                        "name": "unistat-nginx_request_<<codes>>_count_deee",
                    },
                    <% endfor %>
                ],
            },
        <% endfor %>
        {
            "type": "graphic",
            "title": "nginx timings perc, s",
            << flow.coords(width = 3, height = 1) >>,
            "stacked": true,
            "signals": [
                <% for code1, code2 in [ (0.0, 0.1), (0.1, 0.5), (0.5, 1.0), (1.0, 3.0), (3.0, 'inf') ] %>
                {
                    "title": "<< code1 >> - << code2 >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >><< tier >>",
                    "name": "hperc(unistat-nginx_request_total_time_hgram, << code1 >>, << code2 >>)",
                },
                <% endfor %>
            ],
        },

        <#
        # huskydb metrics
        #>
        {
            "type": "text",
            "text": "huskydb metrics",
            << flow.coords(width=12, height = 0.3) >>,
        },
        <% set task_status = [ 'do_not_process', 'pending', 'in_progress', 'complete', 'error' ] %>
        <% set error_types = [ 'transfer_invalid_from_db', 'no_such_user', 'unknown', 'not_supported', 'wrong_args',
                               'failed_write_data', 'failed_get_data',
                               'closed_dest_shard', 'deferred_due_to_message_count_limit', 'user_blocked', 'null' ] %>
        <% set task_types = [ 'transfer', 'clone_user', 'apply_data_migrations', 'delete_mail_user',
                              'delete_shards_user', 'put_letter', 'duplicate_user',
                              'move_messages_to_tabs', 'cut_firstlines', 'onetime_task' ] %>
        {
            "type": "text",
            "text": "Total",
            << flow.coords(width=12, height=0.25) >>
        },
        <% set signal_name_prefix = "%s" | format("unistat-db_task_<" + '|'.join(task_types) + ">") %>
        {
            "type": "graphic",
            "title": "by status",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": false,
            "signals": [
                <% for status in task_status %>
                {
                    "title": "<< status >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "sum( <<signal_name_prefix>>_with_status_<< status >>_axxv )",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "by error_type",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": false,
            "signals": [
                <% for error_type in error_types %>
                {
                    "title": "<< error_type >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "sum( <<signal_name_prefix>>_with_error_type_<< error_type >>_axxv )",
                },
                <% endfor %>
            ],
        },
            {
            "type": "graphic",
            "title": "processed",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": false,
            "signals": [
                {
                    <% set signal_name_prefix = "%s" | format("unistat-db_processed_task_with_type_<" + '|'.join(task_types) + ">") %>
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "sum( <<signal_name_prefix>>_axxv )",
                },
            ],
        },
         <% for task_type in task_types %>
        {
            "type": "text",
            "text": "<<task_type>>",
            << flow.coords(width=12, height=0.25) >>
        },
        {
            "type": "graphic",
            "title": "by status",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for status in task_status %>
                {
                    "title": "<< status >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "unistat-db_task_<< task_type >>_with_status_<< status >>_axxv",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "by error_type",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for error_type in error_types %>
                {
                    "title": "<< error_type >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "unistat-db_task_<< task_type >>_with_error_type_<< error_type >>_axxv",
                },
                <% endfor %>
            ],
        },
            {
            "type": "graphic",
            "title": "processed",
            << flow.coords(width = 4, height = 1.5) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                {
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "unistat-db_processed_task_with_type_<< task_type >>_axxv",
                },
            ],
        },
        <% endfor %>

    ]
}
'''


def primary_template():
    return 'husky', PRIMARY_PANEL_TEMPLATE
