from mail.yasm.lib.commondb import get_dbaas_alerts_template_shards, _DBAAS_ALERTS_NO_SHARDS_QUERY_75_PERCENTILE_MS
from mail.yasm.lib.maildb.constants import ENVIRONMENTS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production', 'any_time_calls'],
    )
    return get_dbaas_alerts_template_shards(
        name='maildb',
        environments=ENVIRONMENTS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        alert_group=_DBAAS_ALERTS_NO_SHARDS_QUERY_75_PERCENTILE_MS,
    )


def primary_template():
    return 'Maildb-dbaas-query_75_percentile_ms-alerts', primary_alerts_template()
