from mail.yasm.lib.commondb import get_dbaas_alerts_template_shards, _DBAAS_ALERTS_NO_SHARDS_CPU_USAGE_PERCENT
from mail.yasm.lib.maildb.constants import ENVIRONMENTS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=600, stable=120),
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=600, stable=120),
    )
    return get_dbaas_alerts_template_shards(
        name='maildb',
        environments=ENVIRONMENTS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        alert_group=_DBAAS_ALERTS_NO_SHARDS_CPU_USAGE_PERCENT,
    )


def primary_template():
    return 'Maildb-dbaas-cpu_usage_percent-alerts', primary_alerts_template()
