from mail.yasm.lib.commondb import get_dbaas_alerts_template_shards, get_max_used_space_alert
from mail.yasm.lib.maildb.constants import ENVIRONMENTS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig

DBAAS_ALERTS_SHARDS_MAX_USED_SPACE_PERCENT = get_max_used_space_alert(87, 90)


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production', 'any_time_calls'],
    )
    return get_dbaas_alerts_template_shards(
        name='maildb',
        environments=ENVIRONMENTS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        alert_group=DBAAS_ALERTS_SHARDS_MAX_USED_SPACE_PERCENT,
    )


def primary_template():
    return 'Maildb-dbaas-max_used_space_percent-alerts', primary_alerts_template()
