from mail.yasm.lib.commondb import get_dbaas_alerts_template_shards, _DBAAS_ALERTS_NO_SHARDS_TREND_REPLICATION_LAG
from mail.yasm.lib.maildb.constants import ENVIRONMENTS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=900, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=900, stable=120),
        tags=['env_production'],
    )
    name = 'maildb'
    return get_dbaas_alerts_template_shards(
        name=name,
        environments=ENVIRONMENTS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        alert_group=_DBAAS_ALERTS_NO_SHARDS_TREND_REPLICATION_LAG,
    )


def primary_template():
    return 'Maildb-dbaas-trend_replication_lag-alerts', primary_alerts_template()
