def get_premade_partitions_alerts_template(signal, name):
    return '''[
    <% set juggler_test = {
        "flaps": {
            "critical": 3000,
            "stable": 600
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 300,
            "stable": 30
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_prod_noncrit = {
        "flaps": {
            "critical": 3000,
            "stable": 600
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict = {
        "testing": juggler_test,
        "production": juggler_prod,
        "intranet-production": juggler_prod,
        "load" : juggler_test,
    } %>
    <% set juggler_noncrit_dict = {
        "testing": juggler_test,
        "production": juggler_prod_noncrit,
        "intranet-production": juggler_prod_noncrit,
        "load" : juggler_test,
    } %>

    <% for env in ["testing", "production", "intranet-production", "load"] %>
        <% set q_prj = "mail.samsara." ~ env %>
        <% for q_ctype in list_ctype(itype="qloud", prj=q_prj, limit=1000) %>
            <% if q_ctype != 'unknown' %>
                <% set q_jhost = "mail.maildb.dbstats." ~ env ~ "." ~ q_ctype %>
                << Alert(
                    name=env ~ "." ~ q_ctype,
                    signal="''' + signal + '''",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                        "ctype": q_ctype,
                    },
                    mgroups=["QLOUD"],
                    warn=[5, 6],
                    crit=[None, 4],
                    value_modify = {
                        "type": "max",
                        "window": 60
                    },
                    juggler_check=juggler_noncrit_dict[env]|merge_with_dict({
                        "host": q_jhost,
                        "service": "premade_partitions." ~ "''' + name + '''"
                    })
                ) >>,
            <% endif %>
        <% endfor %>
    <% endfor %>
]'''


def get_pop3_init_queue_alerts():
    return '''[
    <% set juggler_test = {
        "flaps": {
            "critical": 1500,
            "stable": 300
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 1500,
            "stable": 300
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict = {
        "testing": juggler_test,
        "production": juggler_prod,
        "intranet-production": juggler_prod,
    } %>

    <% for env in ["testing", "production", "intranet-production"] %>
        <% set q_prj = "mail.samsara." ~ env %>
        <% for q_ctype in list_ctype(itype="qloud", prj=q_prj, limit=1000) %>
            <% if q_ctype != 'unknown' %>
                <% set q_jhost = "mail.maildb.dbstats." ~ env ~ "." ~ q_ctype %>
                << TrendAlert(
                    name=env ~ "." ~ q_ctype ~ ".pop3_init_queue",
                    signal="mul(unistat-db_pop3_init_queue_ammv,min(1, round(max(0, diff(unistat-db_pop3_init_queue_ammv, 100)))))",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                        "ctype": q_ctype,
                    },
                    mgroups=["QLOUD"],
                    trend="up",
                    interval=600,
                    value_modify = {
                        "type": "min",
                        "window": 300
                    },
                    warn_perc=0.1,
                    crit_perc=5,
                    juggler_check=juggler_dict[env]|merge_with_dict({
                        "host": q_jhost,
                        "service": "pop3_init_queue"
                    })
                ) >>,
            <% endif %>
        <% endfor %>
    <% endfor %>
]'''
