def get_change_queue_template():
    return '''[
    <% set juggler_prod = {
        "flaps": {
            "critical": 1500,
            "stable": 300
        },
        "tags": ["working_time_calls"],
        "namespace": "mail.doberman"
    } %>
    <% set juggler_dict = {
        "intranet-production": juggler_prod,
    } %>

    <% for env in ["intranet-production"] %>
        <% set q_prj = "mail.samsara." ~ env %>
        <% for q_ctype in list_ctype(itype="qloud", prj=q_prj, limit=1000) %>
            <% if q_ctype != 'unknown' %>
                <% set q_jhost = "mail.maildb.dbstats." ~ env ~ "." ~ q_ctype %>
                << TrendAlert(
                    name=env ~ "." ~ q_ctype ~ ".dobby_change_queue_size",
                    signal="mul(unistat-db_dobby_change_queue_size_ammv,min(1,round(max(0,diff(unistat-db_dobby_change_queue_size_ammv,100)))))",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                        "ctype": q_ctype,
                    },
                    mgroups=["QLOUD"],
                    trend="up",
                    interval=600,
                    value_modify = {
                        "type": "min",
                        "window": 300
                    },
                    warn_perc=1,
                    crit_perc=5,
                    juggler_check=juggler_dict[env]|merge_with_dict({
                        "host": q_jhost,
                        "service": "doberman.change_queue_size"
                    })
                ) >>,
            <% endif %>
        <% endfor %>
    <% endfor %>
]'''


def get_fails_template(name, signal):
    return '''[
    <% set juggler_prod = {
        "flaps": {
            "critical": 1200,
            "stable": 300
        },
        "tags": ["working_time_calls"],
        "namespace": "mail.doberman"
    } %>
    <% set juggler_dict = {
        "intranet-production": juggler_prod,
    } %>
    <% for env in ["intranet-production"] %>
        <% set q_prj = "mail.samsara." ~ env %>
        <% for q_ctype in list_ctype(itype="qloud", prj=q_prj, limit=1000) %>
            <% if q_ctype != 'unknown' %>
                <% set q_jhost = "mail.maildb.dbstats." ~ env ~ "." ~ q_ctype %>
                << Alert(
                    name=env ~ "." ~ q_ctype ~ ".dobby_''' + name + '''",
                    signal="''' + signal + '''",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                        "ctype": q_ctype,
                    },
                    mgroups=["QLOUD"],
                    warn=[None, None],
                    crit=[1, None],
                    juggler_check=juggler_dict[env]|merge_with_dict({
                        "host": q_jhost,
                        "service": "doberman.''' + name + '''"
                    })
                ) >>,
            <% endif %>
        <% endfor %>
    <% endfor %>
]'''


def change_queue_template():
    return 'Maildb-dbstats-dobby_change_queue-alerts', get_change_queue_template()


def dead_workers_template():
    return 'Maildb-dbstats-dobby_dead_workers-alerts',\
           get_fails_template('dead_workers', 'unistat-db_dobby_worker_state_dead_ammv')


def workerless_subscriptions_template():
    return 'Maildb-dbstats-dobby_workerless_subscriptions-alerts',\
           get_fails_template('workerless_subscriptions', 'unistat-db_dobby_workerless_subs_ammv')


def failed_subscriptions_template():
    return 'Maildb-dbstats-dobby_failed_subscriptions-alerts',\
           get_fails_template('failed_subscriptions',
                              'sum(unistat-db_dobby_subs_state_<init|sync|clear|migrate>_fail_ammv)')
