def primary_alerts_template():
    return '''[
    <% set juggler_test = {
        "flaps": {
            "critical": 3000,
            "stable": 600
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 300,
            "stable": 60
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict = {
        "testing": juggler_test,
        "production": juggler_prod,
        "intranet-production": juggler_prod,
        "load" : juggler_test,
    } %>

    <% for env in ["testing", "production", "intranet-production", "load"] %>
        <% set q_prj = "mail.samsara." ~ env %>
        <% for q_ctype in list_ctype(itype="qloud", prj=q_prj, limit=1000) %>
            <% if q_ctype != 'unknown' %>
                <% set q_jhost = "mail.maildb.dbstats." ~ env ~ "." ~ q_ctype %>
                << Alert(
                    name=env ~ "." ~ q_ctype,
                    signal="unistat-db_long_backup_restorations_ammv",
                    tags={
                        "itype": "qloud",
                        "prj": q_prj,
                        "ctype": q_ctype,
                    },
                    mgroups=["QLOUD"],
                    warn=[None, None],
                    crit=[1, None],
                    juggler_check=juggler_dict[env]|merge_with_dict({
                        "host": q_jhost,
                        "service": "long_backup_restorations"
                    })
                ) >>,
            <% endif %>
        <% endfor %>
    <% endfor %>
]'''


def primary_template():
    return 'Maildb-dbstats-long_backup_restorations-alerts', primary_alerts_template()
