PRIMARY_PANEL_TEMPLATE = '''
<% set host = host|default('QLOUD') %>
<% set prj = prj|default('mail.samsara.*', true) %>
<% set geo = geo|default(None) %>
<% set ctype = ctype|default(None) %>
<% set tier = tier|default(None) %>
<% set tag = 'itype=qloud' %>
<% if geo %>
  <% set tag = tag + ";geo={0}".format(geo) %>
<% endif %>
<% if prj %>
  <% set tag = tag + ";prj={0}".format(prj) %>
<% endif %>
<% if ctype %>
  <% set tag = tag + ";ctype={0}".format(ctype) %>
<% endif %>
<% if tier %>
  <% set tag = tag + ";tier={0}".format(tier) %>
<% endif %>
{
    "title": "<< prj >>",
    "type": "panel",
    "editors": ["kremenkov"],
    "charts": [
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_is_here_ammv",
                    "title": "active users in shard",
                },
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_is_not_here_ammv",
                    "title": "users transfered or deleted from shard",
                }
            ],
            "title": "users in shard",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_premade_partitions_*_ammv",
                },
            ],
            "title": "premade partitions count",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_users_acounts_*_ammv",
                },
            ],
            "title": "users acounts by state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_users_messages_*_ammv",
                },
            ],
            "title": "messages by user state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_archive_state_*_ammv",
                },
            ],
            "title": "user arhives by state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_archive_state_outdated_*_ammv",
                },
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_long_archive_restorations_ammv",
                }
            ],
            "title": "user long time archivation processes",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_long_backup_restorations_ammv",
                }
            ],
            "title": "user long time backup restorations processes",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_backups_in_state_*_ammv",
                },
            ],
            "title": "users backups by state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_restores_in_state_*_ammv",
                },
            ],
            "title": "user backup restores by state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_storage_delete_queue_count_ammv",
                },
            ],
            "title": "xdb storage delete queue",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_storage_delete_queue_active_count_ammv",
                },
            ],
            "title": "xdb storage delete queue(active)",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_deleted_box_count_ammv",
                },
            ],
            "title": "xdb deleted box queue",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_trash_count_ammv",
                },
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_spam_count_ammv",
                },
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_hidden_trash_count_ammv",
                },
            ],
            "title": "auto delete queue",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_message_storage_size_ammv",
                },
            ],
            "title": "message storage size",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_state_*_active_ammv",
                },
            ],
            "title": "active db user",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_state_*_idle_ammv",
                },
            ],
            "title": "idle db user",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_table_size_*_ammv",
                },
            ],
            "title": "xdb total top table size",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_folder_type_*_ammv",
                },
            ],
            "title": "xdb messages by folder type",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_table_live_tup_*_ammv",
                },
            ],
            "title": "xdb live tup",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_stat_tup_*_ammv",
                },
            ],
            "title": "db tuple stat",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_pop3_init_queue_ammv",
                },
            ],
            "title": "pop3 init queue",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_data_version_*_ammv",
                },
            ],
            "title": "users data version",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_last_migration_*_ammv",
                },
            ],
            "title": "migration latest version",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_used_size_ammv",
                    "title": "used space in shard",
                },
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_bloat_size_ammv",
                    "title": "space bloat in shard",
                }
            ],
            "title": "space usage in shard",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_dobby_change_queue_size_ammv",
                },
            ],
            "title": "doberman change queue size",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_dobby_worker_state_*_ammv",
                },
            ],
            "title": "doberman worker state",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_dobby_workerless_subs_ammv",
                },
            ],
            "title": "doberman workerless subscriptions",
            "normalize": true
        },
        {
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "<< tag >>",
                    "host": "<< host >>",
                    "name": "unistat-db_dobby_subs_state_*_ammv",
                },
            ],
            "title": "doberman subscriptions state",
            "normalize": true
        },
    ]
}
'''


def primary_template():
    return 'Maildb-dbstats', PRIMARY_PANEL_TEMPLATE
