class Configuration:
    def __init__(self, domain, component, controller_endpoint_sets, client_endpoint_sets, data_source_names,
                 gc, executors, mdb_cid_by_env, panel_name, controller_endpoints_panel_name,
                 client_endpoints_panel_name, jdbc_panel_name, jvm_panel_name):
        self.domain = domain
        self.component = component
        self.controller_endpoint_sets = controller_endpoint_sets
        self.client_endpoint_sets = client_endpoint_sets
        self.data_source_names = data_source_names
        self.gc = gc
        self.executors = executors
        self.mdb_cid_by_env = mdb_cid_by_env
        self.panel_name = panel_name
        self.controller_endpoints_panel_name = controller_endpoints_panel_name
        self.client_endpoints_panel_name = client_endpoints_panel_name
        self.jdbc_panel_name = jdbc_panel_name
        self.jvm_panel_name = jvm_panel_name

    def to_jinja_dict(self):
        def total_signal(code, endpoints):
            return 'sum(' + ','.join([getattr(e, 'signal_' + code)() for e in endpoints]) + ')'

        controllers_total_2xx_signal = total_signal('2xx', self.controller_endpoint_sets)
        controllers_total_4xx_signal = total_signal('4xx', self.controller_endpoint_sets)
        controllers_total_5xx_signal = total_signal('5xx', self.controller_endpoint_sets)

        clients_total_2xx_signal = total_signal('2xx', self.controller_endpoint_sets)
        clients_total_4xx_signal = total_signal('4xx', self.controller_endpoint_sets)
        clients_total_5xx_signal = total_signal('5xx', self.controller_endpoint_sets)

        return {'controllers_total_2xx': controllers_total_2xx_signal,
                'controllers_total_4xx': controllers_total_4xx_signal,
                'controllers_total_5xx': controllers_total_5xx_signal,
                'clients_total_2xx': clients_total_2xx_signal,
                'clients_total_4xx': clients_total_4xx_signal,
                'clients_total_5xx': clients_total_5xx_signal,
                'data_sources': self.data_source_names,
                'mdb_cid_by_env': self.mdb_cid_by_env,
                'controllers_panel_name': self.controller_endpoints_panel_name,
                'clients_panel_name': self.client_endpoints_panel_name,
                'jdbc_panel_name': self.jdbc_panel_name,
                'jvm_panel_name': self.jvm_panel_name}


def generate_brief_panel(name, editors_list, qloud_project_id, env_list, default_env, configurations, default_domain,
                         default_component, layout_height=1, layout_width=3, layout_columns_count=12,
                         header_height=0.2):
    domains = [c.domain for c in configurations]
    components = [c.component for c in configurations]
    configurations_data = {c.component + '_' + c.domain: c.to_jinja_dict() for c in configurations}

    return '''<< suggest.clear() >>
<< suggest.add_var("tier") >>
<< suggest.set_choice_list("tier", [{components}]) >>
<% set tier = tier | default("{default_component}") %>

<< suggest.add_var("domain") >>
<< suggest.set_choice_list("domain", [{domains}]) >>
<% set domain = domain | default("{default_domain}") %>

<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", [{envs}]) >>
<% set env = env | default("{default_env}") %>

<% set q_prj = "{qloud_project_id}" ~ domain ~ "." ~ env %>
<% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";tier=" ~ tier ~ "*" %>

<% set configurations = {configurations} %>
<% set configuration = configurations[tier ~ '_' ~ domain] %>

<# Stolen from CallMeBack panel #>
<% set cid = configuration['mdb_cid_by_env'][env] %>
<% set cid_tags = 'ctype=' ~ cid %>
<% set dom0_tags = 'tier=primary,replica' %>
<% set domu_tags = 'tier=primary,replica' %>

<% set main_layout = create_main_layout("vertical", default_height={layout_height}, default_width={layout_width}) %>

{{
    "title": "{panel_name} (<< tier >>, << env >>)",
    "type": "panel",
    "editors": [{editors}],
    "charts": [
        <% set primary_layout = main_layout.sub('flow', columns={layout_columns_count}) %>
        {{
            "title": "Total controllers requests",
            "type": "graphic",
            "stacked": true,
            "minValue": 0,
            "signals": [
                {{
                    "title": "2xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["controllers_total_2xx"] >>",
                    "color": "<< make_color("2xx", "sparse") >>"
                }},
                {{
                    "title": "4xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["controllers_total_4xx"] >>",
                    "color": "<< make_color("4xx", "sparse") >>"
                }},
                {{
                    "title": "404",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "http_server_requests_4xx_not_found_count_summ",
                    "color": "<< make_color("404", "sparse") >>"
                }},
                {{
                    "title": "5xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["controllers_total_5xx"] >>",
                    "color": "<< make_color("5xx", "sparse") >>"
                }}
            ],
            "links": [
                {{
                    "title": "Details panel",
                    "url": "https://yasm.yandex-team.ru/template/panel/<< configuration['controllers_panel_name'] >>/env=<< env >>"
                }}
            ],
            << primary_layout.coords() >>
        }},
        {{
            "title": "Total clients requests",
            "type": "graphic",
            "stacked": true,
            "minValue": 0,
            "signals": [
                {{
                    "title": "2xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["clients_total_2xx"] >>",
                    "color": "<< make_color("2xx", "sparse") >>"
                }},
                {{
                    "title": "4xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["clients_total_4xx"] >>",
                    "color": "<< make_color("4xx", "sparse") >>"
                }},
                {{
                    "title": "5xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "<< configuration["clients_total_5xx"] >>",
                    "color": "<< make_color("5xx", "sparse") >>"
                }}
            ],
            "links": [
                {{
                    "title": "Details panel",
                    "url": "https://yasm.yandex-team.ru/template/panel/<< configuration['clients_panel_name'] >>/env=<< env >>"
                }}
            ],
            << primary_layout.coords() >>
        }},
        {{
            "title": "JDBC (hikari) pools connections",
            "type": "graphic",
            "minValue": 0,
            "stacked": true,
            "signals": [
                <% for data_source in configuration["data_sources"] %>
                {{
                    "title": "<< data_source >> total",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-hikaricp_connections_<< data_source >>_axxx",
                    "color": "<< make_color(data_source, "sparse") >>"
                }}
                << "," if not loop.last >>
                <%- endfor %>
            ],
            "links": [
                {{
                    "title": "Details panel",
                    "url": "https://yasm.yandex-team.ru/template/panel/<< configuration['jdbc_panel_name'] >>/env=<< env >>"
                }}
            ],
            << primary_layout.coords() >>
        }},
        {{
            "title": "JVM stats, Mb",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                <% for region in ["non_nmethods", "non_profiled_nmethods", "profiled_nmethods"] %>
                {{
                    "title": "Code cache << region >> used",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "conv(unistat-jvm_memory_used_nonheap_codeheap_<< region >>_axxx, Mi)",
                    "color": "<< make_color(region ~ "used", "sparse") >>"
                }},
                <%- endfor %>
                <% for buffer_type in ["direct", "mapped"] %>
                {{
                    "title": "An estimate of the memory that the JVM is using for << buffer_type >> buffer pool, Mb",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "conv(unistat-jvm_buffer_memory_used_<< buffer_type >>_axxx, Mi)",
                    "color": "<< make_color("memory_used" ~ buffer_type, "sparse") >>"
                }}
                << "," if not loop.last >>
                <%- endfor %>
            ],
            "links": [
                {{
                    "title": "Details panel",
                    "url": "https://yasm.yandex-team.ru/template/panel/<< configuration['jvm_panel_name'] >>/env=<< env >>"
                }}
            ],
            << primary_layout.coords() >>
        }},
        {{
            "title": "DB CPU Usage",
            "type": "graphic",
            "stacked": true,
            "normalize": true,
            "yAxis": [
                {{
                    "minValue": 0,
                    "maxValue": 12
                }},
                {{
                    "minValue": 0,
                    "maxValue": 12
                }}
            ],
            "signals": [
                {{
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "Used",
                    "yAxis": 0
                }},
                {{
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "Guaranteed",
                    "stacked": false,
                    "yAxis": 1
                }},
                {{
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "Wait",
                    "yAxis": 0
                }}
            ],
            "links": [{{
                "title": "DBaaS panel",
                "url": "https://yasm.yandex-team.ru/template/panel/dbaas_postgres_metrics/cid=<< cid >>"
            }}],
            << primary_layout.coords() >>
        }},
        <% set alerts_layout = main_layout.sub('flow', columns={layout_columns_count}, default_width=1, default_height=1) %>
        <% set alert_suffix = env ~ '_' ~ tier ~ '_' %>
        <% set alerts = list_alerts(name_pattern="(.*)", hosts="QLOUD", itype="qloud", prj=q_prj, tier=tier ~ '*') %>
        <% for alert in alerts | sort() %>
            <% set alert = alert | string %>
            <% set title = alert.split('.')[-1].split(alert_suffix)[1] %>
            {{
                "type": "alert",
                "name": "<< alert >>",
                "title": "<< title >>",
                "showThresholds": True,
                << alerts_layout.coords() >>
            }}
        << "," if not loop.last >>
        <%- endfor %>
    ]
}}'''.format(qloud_project_id=qloud_project_id,
             panel_name=name,
             editors=','.join(['"' + env + '"' for env in editors_list]),
             default_env=default_env,
             default_component=default_component,
             default_domain=default_domain,
             envs=','.join(['"' + env + '"' for env in env_list]),
             components=','.join(['"' + env + '"' for env in components]),
             domains=','.join(['"' + env + '"' for env in domains]),
             layout_columns_count=layout_columns_count,
             layout_height=layout_height,
             layout_width=layout_width,
             configurations=str(configurations_data))
