def generate_jdbc_panel(name, editors_list, qloud_project_id, env_list, default_env, qloud_component=None,
                        data_source_names=None, layout_height=1, layout_width=3, layout_columns_count=12):
    if data_source_names is None:
        data_source_names = []

    return '''<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", [{envs}]) >>
<% set env = env | default("{default_env}") %>

<% set q_prj = "{qloud_project_id}" ~ "." ~ env %>

<% set q_component = "{qloud_component}" %>
<% if q_component != '' %>
    <% set q_component = 'tier=' ~ q_component ~ '*' %>
<% endif %>

<% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";" ~ q_component %>
<% set data_sources = {data_sources} %>
<% set main_layout = create_main_layout("vertical", default_height={layout_height}, default_width={layout_width}) %>
{{
    "title": "{panel_name} (<< env >>)",
    "type": "panel",
    "editors": [{editors}],
    "charts": [
        <% set primary_layout = main_layout.sub('flow', columns={layout_columns_count}) %>
        <% for data_source in data_sources %>
        {{
            "title": "<< data_source >> pool connections",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                <% for state in ["idle", "pending", "active", "min", "max"] %>
                {{
                    "title": "<< state >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-hikaricp_connections_<< state >>_<< data_source >>_axxx",
                    "color": "<< make_color(state, "sparse") >>"
                }},
                <%- endfor %>
                {{
                    "title": "total",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-hikaricp_connections_<< data_source >>_axxx",
                    "color": "<< make_color("total", "sparse") >>"
                }}
            ],
            "links": [
                {{
                    "title": "Moar about Hikari pool metrics",
                    "url": "https://github.com/brettwooldridge/HikariCP/wiki/Dropwizard-Metrics"
                }}
            ],
            << primary_layout.coords() >>
        }},
        {{
            "title": "<< data_source >> pool connections events",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                <% for event in ["usage", "creation", "acquire"] %>
                {{
                    "title": "<< state >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-hikaricp_connections_<< event >>_<< data_source >>_count_summ",
                    "color": "<< make_color(event, "sparse") >>"
                }},
                <%- endfor %>
                {{
                    "title": "timeout",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-hikaricp_connections_timeout_<< data_source >>_summ",
                    "color": "<< make_color("timeout", "sparse") >>"
                }}
            ],
            "links": [
                {{
                    "title": "Moar about Hikari pool metrics",
                    "url": "https://github.com/brettwooldridge/HikariCP/wiki/Dropwizard-Metrics"
                }}
            ],
            << primary_layout.coords() >>
        }},
        <% for conn_event in ["creation", "acquire", "usage"] %>
        {{
            "title": "<< data_source >> pool connection << conn_event >> time, ms",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                <% for q in [50, 80, 90, 95, 98, 99] %>
                {{
                    "title": "<< q >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "or(quant(unistat-hikaricp_connections_<< conn_event >>_<< data_source >>_time_hgram, << q >>), 0)",
                    "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
                }}
                << "," if not loop.last >>
                <%- endfor %>
            ],
            "links": [
                {{
                    "title": "Moar about Hikari pool metrics",
                    "url": "https://github.com/brettwooldridge/HikariCP/wiki/Dropwizard-Metrics"
                }}
            ],
            << primary_layout.coords() >>
        }}
        << "," if not loop.last >>
        <%- endfor %>
        << "," if not loop.last >>
        <%- endfor %>
    ]
}}'''.format(qloud_project_id=qloud_project_id,
             qloud_component=qloud_component or '',
             panel_name=name,
             editors=','.join(['"' + env + '"' for env in editors_list]),
             envs=','.join(['"' + env + '"' for env in env_list]),
             default_env=default_env,
             data_sources=data_source_names,
             layout_columns_count=layout_columns_count,
             layout_height=layout_height,
             layout_width=layout_width)
