from mail.yasm.lib.commondb import get_dbaas_alerts_template
from mail.yasm.lib.queuedb.constants import CLUSTERS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.maildev',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production', 'any_time_calls'],
    )
    return get_dbaas_alerts_template(
        name="queuedb",
        clusters=CLUSTERS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config
    )


def primary_template():
    return 'Queuedb-max_used_space_percent-alerts', primary_alerts_template()
