def primary_alerts_template():
    return '''[
    <% set juggler_test = {
        "flaps": {
            "critical": 900,
            "stable": 180,
        },
        "namespace": "mail.reminders",
        "tags": ["env_testing"],
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 900,
            "stable": 180,
        },
        "namespace": "mail.reminders",
        "tags": ["env_production", "marty"],
    } %>

    <% set juggler_dict = {
        "testing": juggler_test,
        "production": juggler_prod,
    } %>

    <# Error codes #>
    <% for env, name, warn, crit in [
        ("testing", "api.5xx", [1, 10], [10, None]),
        ("testing", "api.4xx", [10, 30], [30, None]),
        ("production", "api.5xx", [3, 6], [6, None]),
        ("production", "api.4xx", [10, 20], [20, None])
    ] %>
        <% set q_prj = "mail.reminders." ~ env %>
        <% if name == "api.5xx" %>
            <% set signals = list_signals(pattern='unistat-nginx_request_5(\\d+)_count_deee', itype='qloud', prj=q_prj) | join(', ') %>
        <% elif name == "api.4xx" %>
            <% set signals = list_signals(pattern='unistat-nginx_request_4(\\d+)_count_deee', itype='qloud', prj=q_prj) | join(', ') %>
        <% endif %>

        << Alert(
            name=env ~ "." ~ name,
            signal="sum(" ~ signals ~ ")",
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": name
            })
        ) >>,
    <% endfor %>

    <# Quantiles #>
    <% for env in ["testing", "production"] %>
        <% set q_prj = "mail.reminders." ~ env %>
        <% set warn = [2, 5] %>
        <% set crit = [5, None] %>
        << Alert(
            name=env ~ ".callmeback.internal",
            signal="or(unistat-reminders.callmeback.request.internal.error_deee, 0)",
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": "callmeback.internal",
                "flaps": {
                    "critical": 15,
                    "stable": 10,
                }
            })
        ) >>,
        <% set signals = list_signals(pattern='unistat-reminders.callmeback.request.5(\\d+)_deee', itype='qloud', prj=q_prj) | join(', ') %>
        << Alert(
            name=env ~ ".callmeback.5xx",
            signal="or(0, sum(" ~ signals ~ "))",
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": "callmeback.5xx",
                "flaps": {
                    "critical": 15,
                    "stable": 10,
                }
            })
        ) >>,
    <% endfor %>

    <% for env, q, name, warn, crit in [
        ("testing", "80", "api",  [0.2, None], [None, None]),
        ("testing", "95", "api", [0.5, None], [None, None]),
        ("testing", "80", "mongo",  [0.5, None], [None, None]),
        ("testing", "95", "mongo", [1, None], [None, None]),
        ("production", "80", "api", [1, 1], [1, None]),
        ("production", "95", "api", [5, 5], [5, None]),
        ("production", "80", "mongo", [0.6, 0.6], [0.6, None]),
        ("production", "95", "mongo", [0.8, 0.8], [0.8, None])
    ] %>
        <% set q_prj = "mail.reminders." ~ env %>
        <% if name == "api" %>
            <% set signal="quant(unistat-nginx_request_total_time_hgram, " ~ q ~ ")" %>
        <% else %>
            <% set signal="conv(quant(unistat-reminders.mongo.time_buckets_dhhh, " ~ q ~ "), G)" %>
        <% endif %>

        << Alert(
            name=env ~ "." ~ name ~ ".q" ~ q,
            signal=signal,
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": name ~ ".q" ~ q
            })
        ) >>,
    <% endfor %>

    <# Mongo Fail Requests #>
    <% for env, name, warn, crit in [
        ("testing", "mongo.failed_requests", [10, None], [None, None]),
        ("production", "mongo.failed_requests", [5, 5], [5, None])
    ] %>
        <% set q_prj = "mail.reminders." ~ env %>

        <% set mongoHosts = [] %>
        <% if env == 'production' %>
            <% set mongoHosts = ['mongodb1p.mail.yandex.net', 'mongodb1o.mail.yandex.net', 'mongodb1j.mail.yandex.net'] %>
        <% elif env == 'testing' %>
            <% set mongoHosts = ['reminders_test_back.cmail.yandex.net'] %>
        <% endif %>

        <% set signals = [] %>
        <% for host in mongoHosts %>
            <% do signals.append("or(unistat-reminders.mongo.fail.requests." ~ host ~ "_deee, 0)") %>
        <% endfor %>
        <% set signals = signals | join(', ') %>

        << Alert(
            name=env ~ "." ~ name,
            signal="sum(" ~ signals ~ ")",
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": name
            })
        ) >>,
    <% endfor %>

    <# Reminders send fails #>
    <% for env, name, warn, crit in [
        ("testing", "worker.send_fail", [10, None], [None, None]),
        ("production", "worker.send_fail", [10, 10], [10, None])
    ] %>
        <% set q_prj = "mail.reminders." ~ env %>
        <% set signals = 'or(unistat-reminders.send.failed_deee, 0), or(unistat-reminders.send.failed.exception_deee, 0)' %>

        << Alert(
            name=env ~ "." ~ name,
            signal="sum(" ~ signals ~ ")",
            tags={
                "itype": "qloud",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": name
            })
        ) >>,
    <% endfor %>

    <# Unispace #>
    <% set signal_unispace = 'perc(unistat-auto_disk_rootfs_usage_bytes_axxx, unistat-auto_disk_rootfs_total_bytes_axxx)' %>
    <% for env, signals, tier, name, warn, crit in [
        ("testing", signal_unispace, "api", "unispace", [70, 80], [80, None]),
        ("testing", signal_unispace, "worker", "unispace", [70, 80], [80, None]),
        ("production", signal_unispace, "api", "unispace", [70, 80], [80, None]),
        ("production", signal_unispace, "worker", "unispace", [70, 80], [80, None]),
    ] %>
        <% set q_prj = "mail.reminders." ~ env %>

        << Alert(
            name=env ~ "." ~ tier ~ "." ~ name,
            signal=signals,
            tags={
                "itype": "qloud",
                "tier": tier ~ "*",
                "prj": q_prj,
            },
            mgroups=["QLOUD"],
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": tier ~ "." ~ name
            })
        ) >>,
    <% endfor %>
]'''


def primary_template():
    return 'Reminders-alerts', primary_alerts_template()
