PRIMARY_PANEL_TEMPLATE = '''<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", ["testing", "production"]) >>

<% set q_prj = "mail.reminders." ~ env %>
<% set app_tag = "itype=qloud;prj=" ~ q_prj %>

<% set main_layout = create_main_layout("vertical", default_height=1, default_width=2) %>

{
    "title": "Reminders (<< env >>)",
    "type": "panel",
    "charts": [
        <# <% set primary_layout = main_layout.sub('flow', columns=10, default_width=2.5) %> #>
        <% set row1 = main_layout.sub('horizontal', columns=8, default_width=2) %>

        {
            "title": "API Requests",
            "type": "graphic",
            "stacked": true,
            "signals": [
                {
                    "title": "4xx",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".api.4xx").get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-nginx_request_4(\\d+)_count_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#ff5577"
                },
                {
                    "title": "5xx",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".api.5xx").get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-nginx_request_5(\\d+)_count_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#ccaa22"
                },
                {
                    "title": "2xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-nginx_request_2(\\d+)_count_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#2bc687"
                }
            ],
            << row1.coords() >>
        },
        {
            "title": "API Timings",
            "type": "graphic",
            "signals": [
                <% for q in [50, 80, 90, 95, 98, 99] %>
                {
                    "title": "<< q >>",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".api.q" ~ q).get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "quant(unistat-nginx_request_total_time_hgram, << q >>)",
                    "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
                },
                <%- endfor %>
             ],
             << row1.coords() >>
        },
        {
            "title": "Saved reminders with clientId and channel 5min",
            "type": "graphic",
            "stacked": true,
            "minValue": 0,
            "period": 300,
            "signals": [
                <% for num, clientId, channel in [(1, 'others', 'callback'), (2, 'others', 'sup'), (3, 'others', 'xiva'),
                                                  (4, 'yandex_flight', 'cloud_api'), (5, 'yandex_flight', 'email'),
                                                  (6, 'yandex_flight', 'panel'), (7, 'yandex_tv', 'sms'), (8, 'yandex_wmi', 'callback')] %>
                {
                    "title": "<< clientId >>/<< channel >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.saved.reminders.<< clientId >>.<< channel >>_deee",
                    "color": "<< make_color(num, start=1, stop=8, scheme="gradient") >>"
                },
                <%- endfor %>
            ],
            << row1.coords() >>
        },
        {
            "title": "Saved events 5min",
            "type": "graphic",
            "stacked": true,
            "period": 300,
            "signals": [
                {
                    "title": "Saved Events",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.saved.events_deee",
                    "color": "#2bc687"
                }
            ],
            << row1.coords() >>
        },
        <% set row2 = main_layout.sub('horizontal') %>
        {
            "title": "Saved flight tickets 5min",
            "type": "graphic",
            "stacked": true,
            "minValue": 0,
            "period": 300,
            "signals": [
                {
                    "title": "Saved flight tickets",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-reminders.saved.flight.tickets.(\\w+)_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#2bc687"
                }
            ],
            << row2.coords() >>
        },
        {
            "title": "Send reminders statuses 5min",
            "type": "graphic",
            "stacked": true,
            "period": 300,
            "signals": [
                <% for title, status, color in [('Failed', 'failed', '#ff5577'), ('Failed Attempt', 'failed.attempt', '#00adf7'),
                                                ('Failed Exception', 'failed.exception', '#ccaa22'), ('Success', 'success', '#2bc687')] %>
                {
                    "title": "<< title >>",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".worker.send_fail").get() %>
                    <% if alert and status == 'failed' %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.send.<< status >>_deee",
                    "color": "<< color >>"
                },
                <%- endfor %>
            ],
            << row2.coords() >>
        },
        {
            "title": "Send reminders by channel 5min",
            "type": "graphic",
            "stacked": true,
            "period": 300,
            "signals": [
                <% for num, channel in [(1, 'xiva'), (2, 'cloud_api'), (3, 'email'), (4, 'panel'), (5, 'sms'), (6, 'sup')] %>
                {
                    "title": "<< channel >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.send.<< channel >>_deee",
                    "color": "<< make_color(num, start=1, stop=6, scheme="gradient") >>"
                },
                <%- endfor %>
            ],
            << row2.coords() >>
        },
        {
            "title": "Send reminders by clientId 5min",
            "type": "graphic",
            "stacked": true,
            "period": 300,
            "signals": [
                <% for num, clientId in [(1, 'yandex_wmi'), (2, 'others'), (3, 'yandex_flight'), (4, 'yandex_tv')] %>
                {
                    "title": "<< clientId >>",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.send.<< clientId >>_deee",
                    "color": "<< make_color(num, start=1, stop=4, scheme="gradient") >>"
                },
                <%- endfor %>
            ],
            << row2.coords() >>
        },
        <% set row3 = main_layout.sub('horizontal') %>
        <% set mongoHosts = [] %>
        <% if env == 'production' %>
            <% set mongoHosts = ['mongodb1p.mail.yandex.net', 'mongodb1o.mail.yandex.net', 'mongodb1j.mail.yandex.net'] %>
        <% elif env == 'testing' %>
            <% set mongoHosts = ['reminders_test_back.cmail.yandex.net'] %>
        <% endif %>
        <% for mongoHost in mongoHosts %>
            {
                "title": "Requests << mongoHost >>",
                "type": "graphic",
                "stacked": true,
                "signals": [
                    {
                        "title": "Failed",
                        "tag": "<< app_tag >>",
                        "host": "QLOUD",
                        "name": "unistat-reminders.mongo.fail.requests.<< mongoHost >>_deee",
                        "color": "#ff5577"
                    },
                    {
                        "title": "Success",
                        "tag": "<< app_tag >>",
                        "host": "QLOUD",
                        "name": "unistat-reminders.mongo.success.requests.<< mongoHost >>_deee",
                        "color": "#2bc687"
                    },
                ],
                << row3.coords() >>
            },
        <%- endfor %>
        {
             "title": "Mongo Timings",
             "type": "graphic",
             "signals": [
                 <% for q in [50, 80, 90, 95, 98, 99] %>
                 {
                     "title": "<< q >>",
                     <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".mongo.q" ~ q).get() %>
                     <% if alert %>
                        "alertName": "<< alert >>",
                     <% endif %>
                     "tag": "<< app_tag >>",
                     "host": "QLOUD",
                     "name": "conv(quant(unistat-reminders.mongo.time_buckets_dhhh, << q >>), G)",
                     "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
                },
                <%- endfor %>
             ],
             << row3.coords() >>
        },
        <% set row4 = main_layout.sub('horizontal') %>
        {
            "title": "Callmeback Requests",
            "type": "graphic",
            "stacked": true,
            "signals": [
                {
                    "title": "2xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-reminders.callmeback.request.2(\\d+)_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#2bc687"
                },
                {
                    "title": "4xx",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-reminders.callmeback.request.4(\\d+)_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#ff5577"
                },
                {
                    "title": "5xx",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".callmeback.5xx").get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "sum(<% set signals = list_signals(pattern='unistat-reminders.callmeback.request.5(\\d+)_deee', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
                    "color": "#ccaa22"
                },
                {
                    "title": "Internal",
                    <% set alert = list_alerts(name_pattern="Reminders-alerts." ~ env ~ ".callmeback.internal").get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-reminders.callmeback.request.internal.error_deee",
                    "color": "#981687"
                }
            ],
            << row4.coords() >>
        },
        {
            "title": "Callmeback Timings",
             "type": "graphic",
             "signals": [
                 <% for q in [50, 80, 90, 95, 98, 99] %>
                 {
                     "title": "<< q >>",
                     "tag": "<< app_tag >>",
                     "host": "QLOUD",
                     "name": "conv(quant(unistat-reminders.callmeback.request.time_buckets_dhhh, << q >>), G)",
                     "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
                },
                <%- endfor %>
             ],
             << row4.coords() >>
        },
        <% set row5 = main_layout.sub('horizontal', default_width=0.8) %>
        <% for alert in list_alerts(name_pattern="Reminders-alerts." ~ env ~  "(.*)") %>
            <% set alert = alert | string %>
            <% set title = alert.split('.')[2:] | join('.') %>
            {
                "type": "alert",
                "name": "<< alert >>",
                "title": "<< title >>",
                << row5.coords() >>
            },
        <%- endfor %>
    ]
}'''


def primary_template():
    return 'Reminders', PRIMARY_PANEL_TEMPLATE
