from mail.yasm.lib.commondb import get_dbaas_alerts_template
from mail.yasm.lib.sharddb.constants import CLUSTERS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig

_MAX_USED_SPACE_PERCENT = """<< Alert(
        name=env ~ "." ~ q_ctype ~ ".max_used_space_percent",
        signal=signal_space_usage,
        tags={
            "itype": "mailpostgresql",
            "tier": "primary",
            "ctype": q_ctype,
        },
        mgroups=["CON"],
        warn=[80, 85],
        crit=[85, None],
        juggler_check=juggler_dict[env]|merge_with_dict({
            "host": q_jhost,
            "service": "sharddb-max_used_space"
        })
    )|merge_with_dict(abc) >>,
"""

_REPLICATION_LAG = """<< Alert(
        name=env ~ "." ~ q_ctype ~ ".replication_lag",
        signal="push-postgres-replication_lag_tmmx",
        tags={
            "itype": "mailpostgresql",
            "ctype": q_ctype,
        },
        mgroups=["CON"],
        warn=[4, 5],
        crit=[5, None],
        juggler_check=juggler_dict[env]|merge_with_dict({
            "host": q_jhost,
            "service": "sharddb-replication_lag"
        })
    )|merge_with_dict(abc) >>,
"""

_QUERY_99_PERCENTILE_MS = """<< Alert(
        name=env ~ "." ~ q_ctype ~ ".query_99_percentile_ms",
        signal="push-pooler-query_0.99_vmmv",
        tags={
            "itype": "mailpostgresql",
            "ctype": q_ctype,
        },
        mgroups=["CON"],
        warn=[35, 40],
        crit=[40, None],
        juggler_check=juggler_dict[env]|merge_with_dict({
            "host": q_jhost,
            "service": "sharddb-query_99_percentile_ms"
        })
    )|merge_with_dict(abc) >>,
"""

_SYNC_REP_WAIT_EVENTS = """<< Alert(
        name=env ~ "." ~ q_ctype ~ ".sync_rep_wait_events",
        signal="push-postgres_wait_event_IPC_SyncRep_tmmx",
        tags={
            "itype": "mailpostgresql",
            "ctype": q_ctype,
        },
        mgroups=["CON"],
        warn=[8, 10],
        crit=[10, None],
        juggler_check=juggler_dict[env]|merge_with_dict({
            "host": q_jhost,
            "service": "sharddb-sync_rep_wait_events"
        })
    )|merge_with_dict(abc) >>,
"""

_CPU_USAGE_PERCENT = """<< Alert(
        name=env ~ "." ~ q_ctype ~ ".cpu_usage_percent",
        signal="perc(portoinst-cpu_usage_cores_txxx, portoinst-cpu_guarantee_cores_txxx)",
        tags={
            "itype": "mdbdom0",
            "ctype": q_ctype,
        },
        mgroups=["CON"],
        warn=[70, 75],
        crit=[75, None],
        juggler_check=juggler_dict[env]|merge_with_dict({
            "host": q_jhost,
            "service": "sharddb-cpu_usage_percent"
        })
    )|merge_with_dict(abc) >>,
"""


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace="mail.sharpei",
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=["env_testing"],
    )
    prod_juggler_config = JugglerConfig(
        namespace="mail.sharpei",
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=["env_production", "night_calls"],
    )
    alerts = (
        _MAX_USED_SPACE_PERCENT
        + _REPLICATION_LAG
        + _QUERY_99_PERCENTILE_MS
        + _SYNC_REP_WAIT_EVENTS
        + _CPU_USAGE_PERCENT
    )
    return get_dbaas_alerts_template(
        name="sharddb",
        clusters=CLUSTERS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        responsibles=["nickitat"],
        alerts=alerts,
    )


def primary_template():
    return "sharddb-alerts", primary_alerts_template()
