from mail.yasm.lib.commondb import (
    FIELD_ABC,
    FIELD_DBNAME,
    FIELD_ESCALATION,
    FIELD_FOLDER,
    FIELD_ID,
)
from mail.yasm.lib.commondb import JUGGLER_PROD, JUGGLER_TEST


_FOLDER_ID = "fooolifj32mm1k3ab503"


def _get_cluster(cluster_id, dbname, escalation, abc):
    return {
        FIELD_ID: cluster_id,
        FIELD_ESCALATION: escalation,
        FIELD_ABC: abc,
        FIELD_FOLDER: _FOLDER_ID,
        FIELD_DBNAME: dbname,
    }


CLUSTERS = {
    "intranet-production": _get_cluster(
        "mdbm78cpbp77blunrfpo", "sharddb", JUGGLER_PROD, "mail"
    ),
    "production": _get_cluster("mdbd8ebfpfh8ult1t721", "sharddb", JUGGLER_PROD, "mail"),
    "testing": _get_cluster("mdbfi97nl13865k7lfs7", "sharddb", JUGGLER_TEST, "sharpei"),
}
