PRIMARY_ALERT_TEMPLATE = r"""
[
    <% set namespace = "mail.sharpei" %>
    <% set juggler_without_calls = {
        "flaps": {
            "critical": 120,
            "stable": 30
        },
        "namespace": namespace,
    } %>
    <% set juggler_with_calls = {
        "flaps": {
            "critical": 120,
            "stable": 30
        },
        "namespace": namespace,
        "tags": ["working_time_calls"],
    } %>
    <% set juggler_dict_without_calls = {
        "intranet-production-nanny": juggler_without_calls,
        "load": juggler_without_calls,
        "production-nanny": juggler_without_calls,
        "testing-nanny": juggler_without_calls,
    } %>
    <% set juggler_dict_with_calls = {
        "intranet-production-nanny": juggler_with_calls,
        "load": juggler_without_calls,
        "production-nanny": juggler_with_calls,
        "testing-nanny": juggler_without_calls,
    } %>
    <% set mgroup = {
        "intranet-production-nanny": "ASEARCH",
        "load": "ASEARCH",
        "production-nanny": "ASEARCH",
        "testing-nanny": "ASEARCH",
    } %>
    <% set tag = {
        "intranet-production-nanny": {
            "itype": "mailsharpei",
            "ctype": "intranet-production"
        },
        "load": {
            "itype": "mailsharpei",
            "ctype": "load"
        },
        "production-nanny": {
            "itype": "mailsharpei",
            "ctype": "production"
        },
        "testing-nanny": {
            "itype": "mailsharpei",
            "ctype": "testing"
        },
    } %>
    <% set prj_tag = {
        "intranet-production-nanny": "mail-sharpei-intranet-production-nanny",
        "load": "mail-sharpei-load",
        "production-nanny": "mail-sharpei-production-nanny",
        "testing-nanny": "mail-sharpei-testing-nanny",
    } %>
    <% set environments = ["intranet-production-nanny", "load", "production-nanny", "testing-nanny"] %>

    <% set alerting_policy = {
        "intranet-production-nanny": {
            "access_log": {
                "warn": [45, 50],
                "crit": [50, None],
                "night_calls_allowed": true,
            },
            "access_log5xx": {
                "warn": [10, 15],
                "crit": [15, None],
                "night_calls_allowed": true,
            },
            "access_log_conninfo": {
                "warn": [45, 50],
                "crit": [50, None],
            },
            "cpu_guarantee_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "default": {
                "warn": [5, 10],
                "crit": [10, None],
            },
            "http_client_bb_userinfo": {
                "warn": [100, 200],
                "crit": [200, None],
            },
            "memory_anon_unevict_limit_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "meta_database_request_expired_in_apq_queue": {
                "warn": [10, 15],
                "crit": [15, None],
            },
            "meta_polling_error": {
                "warn": [5, 10],
                "crit": [10, None],
                "night_calls_allowed": true,
            },
            "pa_get_all_shards": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "pa_get_user_data": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "polling_status_alive": {
                "warn": [None, -1],
                "crit": [0, 0],
            },
            "polling_status_dead": {
                "warn": [None, -1],
                "crit": [1, None],
            },
            "porto_cores_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_net_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "porto_oom_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_volume_cwd_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_root_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_cores_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_ephemeral_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "shards_polling_error": {
                "warn": [5, 10],
                "crit": [10, None],
                "night_calls_allowed": true,
            },
        },
        "load": {
            "default": {
                "warn": [5, 10],
                "crit": [10, None],
            },
            "memory_anon_unevict_limit_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "polling_status_alive": {
                "warn": [None, -1],
                "crit": [0, 0],
            },
            "polling_status_dead": {
                "warn": [None, -1],
                "crit": [1, None],
            },
            "porto_cores_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_net_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "porto_oom_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_volume_cwd_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_root_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_cores_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_ephemeral_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
        },
        "production-nanny": {
            "access_log": {
                "warn": [35, 40],
                "crit": [40, None],
                "night_calls_allowed": true,
            },
            "access_log4xx": {
                "warn": [1500, 2000],
                "crit": [2000, None],
            },
            "access_log5xx": {
                "warn": [250, 500],
                "crit": [500, None],
                "night_calls_allowed": true,
            },
            "access_log_conninfo": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "cpu_guarantee_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "default": {
                "warn": [5, 10],
                "crit": [10, None],
            },
            "endpoint_provider_error": {
                "warn": [5, 10],
                "crit": [10, None],
                "night_calls_allowed": true,
            },
            "http_client_bb_userinfo": {
                "warn": [100, 200],
                "crit": [200, None],
            },
            "memory_anon_unevict_limit_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "meta_database_request_expired_in_apq_queue": {
                "warn": [250, 500],
                "crit": [500, None],
            },
            "meta_database_request_timeout": {
                "warn": [200, 250],
                "crit": [250, None],
            },
            "meta_polling_error": {
                "warn": [5, 10],
                "crit": [10, None],
                "night_calls_allowed": true,
            },
            "pa_get_all_shards": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "pa_get_user_data": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "polling_status_alive": {
                "warn": [None, -1],
                "crit": [0, 0],
            },
            "polling_status_dead": {
                "warn": [None, -1],
                "crit": [1, None],
            },
            "porto_cores_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_net_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "porto_oom_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_volume_cwd_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_root_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_cores_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_ephemeral_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "shards_polling_error": {
                "warn": [5, 10],
                "crit": [10, None],
                "night_calls_allowed": true,
            },
        },
        "testing-nanny": {
            "access_log": {
                "warn": [300, 500],
                "crit": [500, None],
            },
            "access_log5xx": {
                "warn": [10, 15],
                "crit": [15, None],
            },
            "access_log_conninfo": {
                "warn": [300, 500],
                "crit": [500, None],
            },
            "cpu_guarantee_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "default": {
                "warn": [5, 10],
                "crit": [10, None],
            },
            "http_client_bb_userinfo": {
                "warn": [100, 200],
                "crit": [200, None],
            },
            "memory_anon_unevict_limit_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "meta_database_request_expired_in_apq_queue": {
                "warn": [10, 15],
                "crit": [15, None],
            },
            "pa_get_all_shards": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "pa_get_user_data": {
                "warn": [35, 40],
                "crit": [40, None],
            },
            "polling_status_alive": {
                "warn": [None, -1],
                "crit": [0, 0],
            },
            "polling_status_dead": {
                "warn": [None, -1],
                "crit": [1, None],
            },
            "porto_cores_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_net_usage_perc": {
                "warn": [60, 70],
                "crit": [70, None],
            },
            "porto_oom_count": {
                "warn": [1, 1],
                "crit": [1, None],
            },
            "porto_volume_cwd_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_root_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_cores_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
            "porto_volume_ephemeral_usage_perc": {
                "warn": [80, 90],
                "crit": [90, None],
            },
        },
    } %>

    <% macro create_alert(env, signal, signal_name, name, dc, value_modify, a_geo_tag) %>
        <% set prj = tag[env]["itype"] ~ "." ~ prj_tag[env] %>
        <% if alerting_policy[env][signal_name] is defined %>
            <% set alerting_policy_key = signal_name %>
        <% else %>
            <% set alerting_policy_key = "default" %>
        <% endif %>
        <% if name is not defined %>
            <% set name = signal_name %>
        <% endif %>
        <% if dc is defined and dc is not none %>
            <% set tags = tag[env]|merge_with_dict({"dc": dc}) %>
        <% else %>
            <% set tags = tag[env] %>
        <% endif %>
        <% if a_geo_tag is defined %>
            <% set juggler_tags = [a_geo_tag] %>
        <% else %>
            <% set juggler_tags = [] %>
        <% endif %>
        <% if alerting_policy[env][alerting_policy_key]["night_calls_allowed"] %>
            <% set juggler_check_base = juggler_dict_with_calls[env]|merge_with_dict({
                "tags": ["night_calls"]
            }) %>
        <% else %>
            <% set juggler_check_base = juggler_dict_with_calls[env] %>
        <% endif %>
        <% set alert_base = {
            "name": env ~ "." ~ name,
            "signal": signal,
            "tags": tags,
            "mgroups": [mgroup[env]],
            "warn": alerting_policy[env][alerting_policy_key]["warn"],
            "crit": alerting_policy[env][alerting_policy_key]["crit"],
            "juggler_check": juggler_check_base|merge_with_dict({
                "host": prj,
                "service": "sharpei." ~ env ~ "." ~ name,
                "namespace": namespace,
                "aggregator_kwargs": {
                    "unreach_mode": "force_ok",
                    "unreach_service": [
                        {
                            "check": "yasm_alert:virtual-meta"
                        }
                    ]
                },
            }),
            "juggler_tags": juggler_tags,
        } %>
        <% if value_modify is defined and value_modify is not none %>
            <% set alert_base = alert_base|merge_with_dict({
                "value_modify": value_modify
            }) %>
        <% endif %>
        << Alert(base=alert_base) >>,
    <% endmacro %>

    <% macro create_alert_on_plain_signal(env, signal_name) %>
        <% set signal = "unistat-" ~ signal_name ~ "_summ" %>
        << create_alert(env, signal, signal_name) >>
    <% endmacro %>

    <% macro create_alert_on_quant_signal(env, signal_name, quant, name, dc) %>
        <% set signal = "or(0, quant(unistat-" ~ signal_name ~ "_hgram, " ~ quant ~ "))" %>
        << create_alert(env, signal, signal_name, name, dc) >>
    <% endmacro %>

    <% macro create_alert_on_quant_signal_porto(env, signal_name, quant, name, dc) %>
        <% set signal = "or(0, quant(portoinst-" ~ signal_name ~ "_hgram, " ~ quant ~ "))" %>
        << create_alert(env, signal, signal_name, name, dc) >>
    <% endmacro %>

    <% macro create_alert_on_polling_status(env, host) %>
        <% set hosts = list_signals(pattern="unistat-polling_status_(alive|dead)_(?P<host>.*)_(.+)", itype=tag[env]["itype"], ctype=tag[env]["ctype"]).distinct("host") %>
        <% for host in hosts %>
            <% for status, suffix in [("alive", "annn"), ("dead", "axxx")] %>
                <% set signal = "unistat-polling_status_" ~ status ~ "_" ~ host ~ "_" ~ suffix %>
                <% set name = "polling_status_" ~ status ~ "_" ~ host %>

                <# geo tag is used for setting global downtime during dc maintenance #>
                <# see https://docs.yandex-team.ru/juggler/downtimes#maintenance #>
                <% set a_geo_tag = 'a_geo_' ~ host[:3] %>

                << create_alert(env, signal, "polling_status_" ~ status, name, none, none, a_geo_tag) >>
            <% endfor %>
        <% endfor %>
    <% endmacro %>

    <% macro create_alert_on_non2xx_external_requests(env, endpoint) %>
        <% set signals = list_signals(pattern="unistat-" ~ endpoint ~ "(?P<status>[^2]\\d*)_summ", itype=tag[env]["itype"], ctype=tag[env]["ctype"]) %>
        <% set signal = "sum(" ~ signals | join(", ")  ~ ")" %>
        <% set name = endpoint ~ ".non2xx" %>
        << create_alert(env, signal, endpoint, name) >>
    <% endmacro %>

    <% macro create_alert_on_sharpei_errors(env) %>
        <% set signals = list_signals(pattern="unistat-sharpei_errors_(?P<error>.*)_summ", itype=tag[env]["itype"], ctype=tag[env]["ctype"]) %>
        <% for signal in signals %>
            <% set error = signal.sub("error") %>
            <% set sig = "" ~ signal %>
            << create_alert(env, sig, error) >>
        <% endfor %>
    <% endmacro %>

    <% macro create_alert_on_sharddb_requests_timings(env) %>
        <% set dcs = list_dc(itype=tag[env]["itype"], ctype=tag[env]["ctype"]) %>
        <% set queries = list_signals(pattern='pa_([^_]*db.yandex.net)_(?P<query>[^\.\-]*)_hgram', itype=tag[env]["itype"], ctype=tag[env]["ctype"]).distinct('query') %>
        <% for dc in dcs %>
            <% for query in queries %>
                <% set signals = list_signals(pattern="pa_(?P<host>.*)_" ~ query ~ "_hgram", itype=tag[env]["itype"], ctype=tag[env]["ctype"]) %>
                <% for signal in signals %>
                    <% set sig = "or(0, quant(unistat-pa_" ~ signal.sub("host") ~ "_" ~ query ~ "_hgram, 99))" %>
                    <% set name = dc ~ "." ~ "pa_" ~ query ~ "_" ~ signal.sub("host") ~ "_99_quant_ms" %>
                    << create_alert(env, sig, "pa_" ~ query, name, dc) >>
                <% endfor %>
            <% endfor %>
        <% endfor %>
    <% endmacro %>

    <% macro create_alert_summ_in_window(env, signal, signal_name, window_scnds) %>
        <% set value_modify = {
            "type": "summ",
            "window": window_scnds
        } %>
        << create_alert(env, signal, signal_name, name, dc, value_modify) >>
    <% endmacro %>

    <% for env in environments %>
        <% if env != "testing-nanny" %>
            << create_alert_on_plain_signal(env, "access_log4xx") >>
        <% endif %>

        <% if env != "load" %>
            << create_alert_on_plain_signal(env, "access_log5xx") >>

            << create_alert_on_quant_signal(env, "access_log_conninfo", 99, "/conninfo_timings_99_quant_ms") >>
            << create_alert_on_quant_signal(env, "access_log", 99, "access_log_timings_99_quant_ms") >>

            << create_alert_on_sharddb_requests_timings(env) >>

            << create_alert_on_sharpei_errors(env) >>

            << create_alert_on_quant_signal_porto(env, "cpu_guarantee_usage_perc", 99, "porto_cpu_usage_perc") >>
        <% endif %>

        << create_alert_on_quant_signal(env, "http_client_bb_userinfo", 99, "bb_userinfo_timings_99_quant_ms") >>

        << create_alert_on_polling_status(env) >>

        << create_alert_on_non2xx_external_requests(env, "http_client_bb_userinfo") >>

        << create_alert_on_quant_signal_porto(env, "memory_anon_unevict_limit_usage_perc", 99, "porto_mem_usage_perc") >>

        <# sadly guarantees on net are not inforced on yp-pods (RTCSUPPORT-10530), so we add division here 'cause limit is 4 times greater than guarantee #>
        <% set signal = "perc(max(portoinst-net_rx_mb_summ, portoinst-net_tx_mb_summ), div(portoinst-net_limit_mb_summ, 4))" %>
        << create_alert(env, signal, "porto_net_usage_perc") >>

        <% set signals = list_signals(pattern="volume_(?P<volume_name>.*)_usage_perc_txxx", itype=tag[env]["itype"], ctype=tag[env]["ctype"]) %>
        <% for signal in signals %>
            <% set volume_name = signal.sub("volume_name") %>
            << create_alert(env, "portoinst-volume_" ~ volume_name ~ "_usage_perc_txxx", "porto_volume_" ~ volume_name|replace("/", "") ~ "_usage_perc") >>
        <% endfor %>

        << create_alert_summ_in_window(env, "portoinst-ooms_summ", "porto_oom_count", 3600) >>
        << create_alert_summ_in_window(env, "hsum(portoinst-cores_total_hgram)", "porto_cores_count", 3600) >>
    <% endfor %>
]
"""


def primary_template():
    return "sharpei", PRIMARY_ALERT_TEMPLATE
