PRIMARY_ALERT_TEMPLATE = '''
[
<% set juggler_test = {
        "flaps": {
            "critical": 3000,
            "stable": 600
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 3000,
            "stable": 600
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict = {
        "test": juggler_test,
        "prod": juggler_prod,
        "corp": juggler_prod,
        "load": juggler_test,
    } %>

    <% for env in ["test", "prod", "corp", "load"] %>
        <% set q_prj = "mail.shiva." ~ env %>
        <% for task_name in ['cleanup_doomed','end_prepared_transaction','folder_archivation','init_pop3_folders',
                'pg_partman_maintenance','purge_chained_log','purge_deleted_box','purge_storage',
                'space_balancer','settings_export','huskydb_pg_partman_maintenance','queuedb_pg_partman_maintenance',
                'close_for_load','transfer_users','purge_transferred_user','purge_deleted_user',
                'purge_synced_deleted_box','transfer_active_users','reactivate_users','deactivate_users','start_freezing_users',
                'notify_users','freeze_users','archive_users','purge_archives','clean_archives','callmebackdb_clean'] %>
            << Alert(
                name=env ~ ".stuck_task." ~ task_name,
                signal="max(0, abs(diff(unistat-running_" ~ task_name ~ "_ammm, unistat-" ~ task_name ~ "_enqueued_ammm)))",
                tags={
                    "itype": "qloud",
                    "prj": q_prj,
                },
                mgroups=["QLOUD"],
                warn=[1, 1],
                crit=[1, None],
                value_modify = {
                    "type": "min",
                    "window": 60
                },
                juggler_check=juggler_dict[env]|merge_with_dict({
                    "host": q_prj,
                    "service": "stuck_task." ~ task_name
                })
            ) >>,
             << Alert(
                name=env ~ ".task_fail_perc." ~ task_name,
                signal="div(
                        hcount(unistat-" ~ task_name ~ "_fail_s_ahhh),
                        max(10, sum(
                                hcount(unistat-" ~ task_name ~ "_fail_s_ahhh),
                                hcount(unistat-" ~ task_name ~ "_success_s_ahhh)
                        )))",
                tags={
                    "itype": "qloud",
                    "prj": q_prj,
                },
                mgroups=["QLOUD"],
                warn=[0.45, 0.5],
                crit=[0.5, None],
                value_modify = {
                    "type": "min",
                    "window": 60
                },
                juggler_check=juggler_dict[env]|merge_with_dict({
                    "host": q_prj,
                    "service": "task_fail_perc." ~ task_name
                })
            ) >>,
        <% endfor %>
    <% endfor %>
]
'''


def primary_template():
    return 'shiva', PRIMARY_ALERT_TEMPLATE
