PRIMARY_PANEL_TEMPLATE = r'''
<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", ["test", "prod", "corp", "load"]) >>

<% set host = "QLOUD" %>
<% set service = "shiva" %>
<% set prj = "mail." ~ service ~ "." ~ env %>
<% set tag = "itype=qloud;prj=" ~ prj %>

<% set main_layout = create_main_layout("vertical") %>

<% set timings_buckets = [ (0, 1), (1, 10), (10, 60), (60, 300), (300, 600), (600, 1200), (1200, 1800), (1800, 3600),
        (3600, 7200), (7200, 36000), (36000, 'inf') ] %>

{
    "title": "shiva (<< env >>)",
    "type": "panel",
    "key": "shiva_panel",
    "charts": [
        <% set primary_layout = main_layout.sub('flow', columns=6, default_height=1.5) %>

        {
            "type": "text",
            "text": "notify_user details",
            << primary_layout.coords(width=6, height=0.25) >>
        },
        <% set notify_user_status = [ 'cannot_resolve_users', 'successfully_sended', 'missing_uid', 'missing_sid2',
                'successfully_sended_with_strange_response', 'missing_email', 'blackbox_error', 'sendr_error',
                'sendr_exception' ] %>
        {
            "title": "notify_user details",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for status in notify_user_status %>
                {
                    "title": "<< status >>",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "max(0, unistat-notify_users_<< status >>_ammm)",
                },
                <% endfor %>
            ],
            << primary_layout.coords(width=6) >>
        },

        {
            "type": "text",
            "text": "s3 details",
            << primary_layout.coords(width=6, height=0.25) >>
        },
        {
            "title": "s3 requests details",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for signal in list_signals(pattern='unistat-s3_(\S+)_(ok|error)_ammm', itype='qloud', prj=prj) %>
                {
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "<<signal>>",
                },
                <% endfor %>
            ],
            << primary_layout.coords(width=6) >>
        },

        {
            "type": "text",
            "text": "http stats",
            << primary_layout.coords(width=6, height=0.25) >>
        },

        <% set services = ['sharpei', 'storage', 'shiva', 'sender', 'blackbox'] %>
        <% for service in services %>
        {
            "title": "<<service>> timings, ms",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for signal in list_signals(pattern='unistat-http_(\S*)' ~ service ~ '(\S+)_ms_hgram', itype='qloud', prj=prj) %>
                <% for lhs, rhs in timings_buckets %>
                {
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "hperc(<<signal>>, <<lhs>>, <<rhs>>)",
                },
                <% endfor %>
                <% endfor %>
            ],
            << primary_layout.coords(width=3) >>
        },

        {
            "title": "<<service>> http codes",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for signal in list_signals(pattern='unistat-http_(\S*)' ~ service ~ '(\S+)_summ', itype='qloud', prj=prj) %>
                {
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "<<signal>>",
                },
                <% endfor %>
            ],
            << primary_layout.coords(width=3) >>
        },
        <% endfor %>

        {
            "type": "text",
            "text": "Total tasks stats",
            << primary_layout.coords(width=6, height=0.25) >>
        },
        {
            "title": "enqueued",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {
                    "title": "total number queued tasks",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    <% set signals = list_signals(pattern='unistat-(\S+)_enqueued_ammm', itype='qloud', prj=prj) %>
                    "name": "sum(<< signals | join(', ')>>)",
                },
                {
                    "title": "total number running in db tasks",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    <% set signals = list_signals(pattern='unistat-running(\S+)_ammm', itype='qloud', prj=prj) %>
                    "name": "sum(<< signals | join(', ')>>)",
                },
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "completion status",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {
                    "title": "successes",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    <% set signals = list_signals(pattern='unistat-(\S+)_success_s_ahhh', itype='qloud', prj=prj) %>
                    "name": "hcount(hmerge(<< signals | join(', ')>>))",
                    "color": "#2bc687",
                },
                {
                    "title": "fails",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    <% set signals = list_signals(pattern='unistat-(\S+)_fail_s_ahhh', itype='qloud', prj=prj) %>
                    "name": "hcount(hmerge(<< signals | join(', ')>>))",

                    "color": "#ff5577",
                },
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "timings, s",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for lhs, rhs in timings_buckets %>
                {
                   "tag": "<<tag>>",
                   "host": "<< host >>",
                   <% set signals = list_signals(pattern='unistat-(\S+)_s_ahhh', itype='qloud', prj=prj) %>
                   "name": "hperc(hmerge(<< signals | join(', ')>>), <<lhs>>, <<rhs>>)",
                   "title": "(<<lhs>>, <<rhs>>)"

                },
                <% endfor %>
            ],
            << primary_layout.coords() >>
        },

        <% for task_name in ['cleanup_doomed','end_prepared_transaction','folder_archivation','init_pop3_folders',
                'pg_partman_maintenance','purge_chained_log','purge_deleted_box','purge_storage','purge_backups',
                'space_balancer','settings_export','huskydb_pg_partman_maintenance','queuedb_pg_partman_maintenance',
                'close_for_load','transfer_users','purge_transferred_user','purge_deleted_user',
                'purge_synced_deleted_box','transfer_active_users','reactivate_users','deactivate_users','start_freezing_users',
                'notify_users','freeze_users','archive_users', 'purge_archives', 'clean_archives', 'callmebackdb_clean'] %>
        {
            "type": "text",
            "text": "<<task_name>>",
            << primary_layout.coords(width=6, height=0.25) >>
        },
        {
            "title": "enqueued",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "unistat-<<task_name>>_enqueued_ammm",
                },
                {
                    "title": "running in db tasks",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "unistat-running_<<task_name>>_ammm",
                },
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "completion status",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {
                    "title": "successes",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "hcount(unistat-<<task_name>>_success_s_ahhh)",
                    "color": "#2bc687",
                },
                {
                    "title": "fails",
                    "tag": "<<tag>>",
                    "host": "<< host >>",
                    "name": "hcount(unistat-<<task_name>>_fail_s_ahhh)",
                    "color": "#ff5577",
                },
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "timings, s",
            "type": "graphic",
            "normalize": false,
            "stacked": true,
            "minValue": 0,
            "signals": [
                <% for lhs, rhs in timings_buckets %>
                {
                   "tag": "<<tag>>",
                   "host": "<< host >>",
                   "name": "hperc(hmerge(unistat-<<task_name>>_<success|fail>_s_ahhh), <<lhs>>, <<rhs>>)",
                },
                <% endfor %>
            ],
            << primary_layout.coords() >>
        },
        <% endfor %>
    ]
}
'''


def primary_template():
    return 'shiva', PRIMARY_PANEL_TEMPLATE
