from importlib import import_module


def __show_template(header, template):
    print("""
=================================================================================
=================================================================================
{header}
=================================================================================
=================================================================================
{template}


""".format(header=header, template=template))


def show(projects):
    for project in projects:
        project_module = import_module('mail.yasm.lib.{project}'.format(project=project))
        for (alert, template) in project_module.alert_templates():
            __show_template('Alert: ' + alert, template)

        for (panel, template) in project_module.panel_templates():
            __show_template('Panel: ' + panel, template)
