PRIMARY_ALERT_TEMPLATE = '''
[
    <% set juggler_without_calls = {
        "flaps": {
            "critical": 60,
            "stable": 30
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict_without_calls = {
        "testing": juggler_without_calls,
        "prestable": juggler_without_calls,
        "production": juggler_without_calls,
    } %>

    <% set perc_alert_pattern = "perc(%s, or(%s, 1))"%>
    <% set mgroups = ["QLOUD"] %>

    <% for env in ["testing", "production", "prestable"] %>
        <% set q_prj = "mail.spaniel." ~ env %>
        <% set tags= { "itype":"qloud", "prj": q_prj } %>

        <% set alert_name = "%s_nginx_5xx" | format(env) %>
        <% set signal = perc_alert_pattern | format(
            "unistat-nginx_request_5xx_count_deee",
            "unistat-nginx_request_total_count_deee") %>

        << Alert(
                name=alert_name,
                signal=signal,
                tags=tags,
                mgroups=mgroups,
                warn=[1, 2],
                crit=[2, None],
                juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                    "host": q_prj,
                    "service": alert_name
                })
        ) >>,

        <% if env != "testing" %>
            <% set alert_name = "%s_nginx_4xx" | format(env) %>
            <% set signal = perc_alert_pattern | format(
                "unistat-nginx_request_4xx_count_deee",
                "unistat-nginx_request_total_count_deee") %>

            << Alert(
                    name=alert_name,
                    signal=signal,
                    tags=tags,
                    mgroups=mgroups,
                    warn=[1, 2],
                    crit=[2, None],
                    juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                        "host": q_prj,
                        "service": alert_name
                    })
            ) >>,
        <% endif %>

        <% set alert_name = "%s_task_async_search_fails" | format(env) %>
        <% set signal = perc_alert_pattern | format(
            "unistat-failed_summ",
            "sum(unistat-success_summ, unistat-failed_summ)") %>
        << Alert(
            name=alert_name,
            signal=signal,
            tags=tags|merge_with_dict({"ctype": "async_search"}),
            mgroups=mgroups,
            warn=[1, 2],
            crit=[2, None],
            value_modify = {
                "type": "summ",
                "window": 60
            },
            juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                "host": q_prj,
                "service": alert_name
            })
        ) >>,

    <% endfor %>
]
'''


def primary_template():
    return 'spaniel', PRIMARY_ALERT_TEMPLATE
