PRIMARY_PANEL_TEMPLATE = r'''
<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", ["testing", "production", "prestable"]) >>

<% set only_canary = only_canary|default("false") %>
<< suggest.set_choice_list("only_canary", [ "false", "true" ]) >>

<% set host = "QLOUD" %>
<% set service = "spaniel" %>
<% set prj = "mail." ~ service ~ "." ~ env %>
<% set tag = "itype=qloud;prj=" ~ prj %>

<% set data_centers = ['iva', 'myt', 'sas', 'vla', 'man'] %>

<% if only_canary == "true" %>
    <% set tier = ";tier=" ~ service ~ "-canary*" %>
    <% set panel_title = service ~ "-canary (" ~ env ~ ")" %>
<% else %>
    <% set tier = "" %>
    <% set panel_title = service ~ " (" ~ env ~ ")" %>
<% endif %>

<% set main = create_main_layout("vertical") %>

<% set flow = main.sub("flow", columns = 12) %>


{
    "title": "spaniel (<< env >>)",
    "type": "panel",
    "key": "spaniel_panel",
    "charts": [
        <#
        # nginx metrics
        #>
        {
            "type": "text",
            "text": "nginx metrics",
            << flow.coords(width = 12, height = 1) >>,
        },
        {
            "type": "graphic",
            "title": "nginx codes, rps",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ '2xx', '3xx', '4xx', '5xx' ] %>
                {
                    "title": "<< code >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >><< tier >>",
                    "name": "unistat-nginx_request_<< code >>_count_deee",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx requests by dc, rps",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for geo in data_centers %>
                {
                    "title": "<< geo >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >><< tier >>",
                    "name": "unistat-nginx_request_total_count_deee",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx timings perc, sec",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code1, code2 in [ (0.0, 0.1), (0.1, 0.5), (0.5, 1.0), (1.0, 3.0), (3.0, 'inf') ] %>
                {
                    "title": "<< code1 >> - << code2 >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >><< tier >>",
                    "name": "hperc(unistat-nginx_request_total_time_hgram, << code1 >>, << code2 >>)",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx 2xx, rps",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 200 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >><< tier >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx 5xx, rps",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 500, 502, 503, 504, 505 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >><< tier >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx 4xx, rps",
            << flow.coords(width = 4, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 400, 401, 403, 404, 499 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >><< tier >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },

        <#
        # http client metrics
        #>
        {
            "type": "text",
            "text": "http client metrics",
            << flow.coords(width=12, height = 1) >>,
        },

        <% set http_services = [ 'blackbox', 'directory', 'msearch', 'sendbernar', 'meta', 'mbody' ] %>

        <% for http_service in http_services %>
        {
            "type": "graphic",
            "title": "<< http_service >> http codes",
            "stacked": true,
            "normalize": true,
            << flow.coords(width=2, height=1) >>,
            "signals": [
                {
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "host": "<< host >>",
                    "name": "unistat-http_client_*<< http_service >>*_*_summ",
                },
            ],
        },
        <% endfor %>

        {
            "type": "text",
            "text": "",
            << flow.coords(width=12, height=0) >>,
        },

        <% for http_service in http_services %>
        <% for sig in list_signals(pattern='unistat-http_client_.*' ~ http_service ~ '.*_hgram', itype='qloud', prj=('mail.' ~ service ~ '.' ~ env)) %>
        {
            "type": "graphic",
            "title": "<< http_service >> http timings, ms",
            "stacked": true,
            "normalize": true,
            << flow.coords(width=2, height=1) >>,
            "signals": [
                <% for l, r in [ (0, 20), (20, 50), (50, 100), (100, 300), (300, 500), (500, 'inf') ] %>
                {
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "host": "<< host >>",
                    "name": "hperc(<<sig>>, <<l>>, <<r>>)",
                },
                <% endfor %>
            ],
        },
        <% endfor %>
        <% endfor %>

        <#
        # unistat daemon metrics
        #>
        {
            "type": "text",
            "text": "unistat daemon metrics",
            << flow.coords(width=12, height = 1) >>,
        },
        {
            "type": "graphic",
            "title": "parse errors",
            "stacked": true,
            "normalize": true,
            << flow.coords(width=3, height=1) >>,
            "signals": [
                {
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "host": "<< host >>",
                    "name": "*_parse_error_summ",
                },
            ],
        },
        {
            "type": "graphic",
            "title": "unexpected exceptions",
            "stacked": true,
            "normalize": true,
            << flow.coords(width=3, height=1) >>,
            "signals": [
                {
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "host": "<< host >>",
                    "name": "*_exception_summ",
                },
            ],
        },
    ]
}

'''


def primary_template():
    return 'spaniel', PRIMARY_PANEL_TEMPLATE
