PRIMARY_PANEL_TEMPLATE = '''
<< suggest.clear() >>
<< suggest.set_choice_list('env', [
    'production',
    'testing',
]) >>

<% set clusters = {
    'production': 'mdbqpl3a2tftham7ikuh',
    'testing': 'mdbk87lgmrido9bdcge0',
} %>

<% set cid = clusters[env] %>

<% set cid_tags = 'ctype=' ~ cid %>
<% set dom0_tags = dom0_tags ~ 'tier=primary' %>
<% set domu_tags = domu_tags ~ 'tier=primary' %>

<% set dbname = 'spanieldb' %>

<% set main = create_main_layout("vertical") %>
<% set flow = main.sub("flow", columns = 6) %>

{
    "title": "Environment: << env >>; Cluster: << cid >>; Database: << dbname >>",
    "type": "panel",
    "key": "spanieldb_panel",
    "charts": [
        {
            "id": "cpu",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "Used",
                    "yAxis": 0
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "Guaranteed",
                    "stacked": false,
                    "yAxis": 1
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_limit_cores_tmmv",
                    "title": "Limit",
                    "stacked": false,
                    "yAxis": 1
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "Wait",
                    "yAxis": 0
                }
            ],
            "title": "CPU (Cores)",
            "stacked": true,
            "normalize": true
        },
        {
            "id": "mem",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_usage_gb_tmmv",
                    "title": "Used"
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_guarantee_gb_tmmv",
                    "title": "Guaranteed"
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_limit_gb_tmmv",
                    "title": "Limit"
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-anon_usage_gb_tmmv",
                    "title": "Anon used"
                }
            ],
            "title": "Memory (GB)",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "io",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-io_read_fs_bytes_tmmv",
                    "title": "read",
                    "normalizable": true,
                    "yAxis": 0
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-io_write_fs_bytes_tmmv",
                    "title": "write",
                    "normalizable": true,
                    "yAxis": 0
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-io_limit_bytes_tmmv",
                    "title": "limit",
                    "stacked": false,
                    "normalizable": true,
                    "yAxis": 1
                }
            ],
            "title": "I/O (B/s)",
            "stacked": true,
            "normalize": true
        },
        {
            "id": "net",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "conv(portoinst-net_mb_summ, 0.125)",
                    "title": "Used"
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "conv(portoinst-net_guarantee_mb_summ, 0.125)",
                    "title": "Guaranteed"
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "conv(portoinst-net_limit_mb_summ, 0.125)",
                    "title": "Limit"
                }
            ],
            "title": "Network (MBit/s)",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "conn",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_active_vmmv",
                    "yAxis": 0,
                    "title": "active"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_idle_vmmv",
                    "yAxis": 0,
                    "title": "idle"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_idle_in_transaction_vmmv",
                    "yAxis": 0,
                    "title": "idle in transaction"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_aborted_vmmv",
                    "yAxis": 0,
                    "title": "aborted"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_waiting_vmmv",
                    "yAxis": 0,
                    "title": "waiting"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "pgbouncer-bouncer_<< dbname >>_tcp_connections_vmmv",
                    "yAxis": 1,
                    "title": "bouncer"
                }
            ],
            "title": "Connections",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "avgq",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-pooler-avg_query_time_vmmv",
                    "title": "avg statement, (ms)"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-pooler-avg_xact_time_vmmv",
                    "title": "avg transaction, (ms)"
                }
            ],
            "title": "Average query (ms)",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "rps",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "sum(pgbouncer-bouncer_<< dbname >>_total_requests_ps_mmmm, pgbouncer-bouncer_<< dbname >>_total_query_count_ps_mmmm)",
                    "title": "statements per second"
                },
                {
                    "tag": "itype=mailpostgresql;<< cid_tags >>;<< domu_tags >>",
                    "host": "CON",
                    "name": "push-pooler-xact_count_vmmv",
                    "title": "transactions per second"
                }
            ],
            "title": "RPS",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "size",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "minValue": 0,
            "signals": [
                {
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_pg_database_size_vmmv",
                    "title": "db_size (bytes)"
                },
                {
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-disk-total_bytes_/var/lib/postgresql_vmmv",
                    "title": "total_space (bytes)"
                },
                {
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-disk-used_bytes_/var/lib/postgresql_vmmv",
                    "title": "used_space (bytes)"
                },
                {
                    "title": "wal size (bytes)",
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-disk-path-size_pg_wal_bytes_vmmv"
                },
                {
                    "title": "temp file size (bytes)",
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-disk-path-size_pgsql_tmp_bytes_vmmv"
                }
            ],
            "title": "Database size (on primary)",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "errors",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "signals": [
                {
                    "tag": "itype=pgaasproxy",
                    "host": "CON",
                    "name": "pgbouncer_log-log_db-<< dbname >>-warns_mmmm",
                    "title": "Proxy warnings"
                },
                {
                    "tag": "itype=mailpostgresql;<< domu_tags >>",
                    "host": "CON",
                    "name": "postgresql_log-log_db-<< dbname >>-warns_mmmm",
                    "title": "PostgreSQL warnings"
                },
                {
                    "tag": "itype=mailpostgresql;<< domu_tags >>",
                    "host": "CON",
                    "name": "postgresql_log-log_db-<< dbname >>-errors_mmmm",
                    "title": "PostgreSQL errors"
                },
                {
                    "tag": "itype=mailpostgresql;<< domu_tags >>",
                    "host": "CON",
                    "name": "postgresql_log-log_db-<< dbname >>-fatals_mmmm",
                    "title": "PostgreSQL fatals"
                }
            ],
            "title": "Log errors",
            "normalize": false,
            "stacked": false
        },
        {
            "id": "wait",
            "type": "graphic",
            "width": 2,
            "height": 1,
            "minValue": 0,
            "signals": [
                {
                    "tag": "itype=mailpostgresql;tier=primary;<< cid_tags >>",
                    "host": "CON",
                    "name": "push-postgres_wait_event_*"
                }
            ],
            "title": "Wait event stat (on primary)",
            "stacked": true,
            "normalize": true
        }
    ]
}
'''


def primary_template():
    return 'spanieldb', PRIMARY_PANEL_TEMPLATE
