PRIMARY_ALERT_TEMPLATE = '''
[
    <% set juggler_without_calls = {
        "flaps": {
            "critical": 300,
            "stable": 120
        },
        "namespace": "mail.york"
    } %>
    <% set juggler_working_time_calls = juggler_without_calls | merge_with_dict({
        "tags": ["working_time_calls"]
    }) %>
    <% set juggler_any_time_calls = juggler_without_calls | merge_with_dict({
        "tags": ["any_time_calls"]
    }) %>
    <% set juggler_dict = {
        "production": juggler_working_time_calls,
        "prestable": juggler_without_calls,
        "testing": juggler_without_calls,
    } %>

    <% for env in ["production", "prestable", "testing"] %>
        <% set q_prj = "mail.york-corp." ~ env %>
        << Alert(
                name=env ~ ".york.5xx",
                signal="or(perc(unistat-nginx_request_5xx_count_deee, unistat-nginx_request_total_count_deee), 0)",
                tags={
                    "itype": "qloud",
                    "prj": q_prj,
                },
                mgroups=["QLOUD"],
                warn=[1, 5],
                crit=[5, None],
                juggler_check=juggler_dict[env]|merge_with_dict({
                    "host": q_prj,
                    "service": "york.5xx"
                })
        ) >>,
        <% for worker_type in ["york", "worker"] %>
            << Alert(
                name=env ~ "." ~ worker_type ~ ".errors",
                signal="sum(unistat-" ~ worker_type ~ "_errors_<apq|macs|pg_common|pg_connection|pg_database|pg_readonly|pg_repository|pg_sql|sharpei_client|unexpected_error>_summ)",
                tags={
                    "itype": "qloud",
                    "prj": q_prj,
                },
                mgroups=["QLOUD"],
                warn=[1, 3],
                crit=[3, None],
                juggler_check=juggler_dict[env]|merge_with_dict({
                    "host": q_prj,
                    "service": "york." ~ worker_type ~ ".errors"
                })
            ) >>,
        <% endfor %>
    <% endfor %>
]
'''


def primary_template():
    return 'york', PRIMARY_ALERT_TEMPLATE
