PRIMARY_PANEL_TEMPLATE = r'''
<< suggest.clear() >>
<< suggest.set_choice_list("env", [ "production", "prestable"]) >>

<% set env = env | default("production") %>

<% set host = "QLOUD" %>
<% set service = "york-corp" %>
<% set data_centers = ['iva', 'myt', 'sas', 'vla', 'man'] %>

<% set panel_title = service ~ " (" ~ env ~ ")" %>

<% set main = create_main_layout("vertical") %>
<% set flow = main.sub("flow", columns = 4) %>


{
    "title": "<< panel_title >>",
    "type": "panel",
    "key": "york_panel",
    "editors": [],
    "charts": [

        <#
        # nginx metrics
        #>
        {
            "type": "text",
            "text": "nginx metrics",
            << flow.coords(width = 4, height = 0.3) >>,
        },
        {
            "type": "graphic",
            "title": "nginx 2xx, rps",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 200 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx 5xx, rps",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 500, 502, 503, 504 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx 4xx, rps",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ 400, 401, 403, 404, 405, 499 ] %>
                    <% for geo in data_centers %>
                    {
                        "title": "<< code >> << geo >>",
                        "host": "<< host >>",
                        "tag": "itype=qloud;prj=mail.<< service >>.<< env >>;geo=<< geo >>",
                        "name": "unistat-nginx_request_<< code >>_count_deee",
                    },
                    <% endfor %>
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "nginx timings perc, sec",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code1, code2 in [ (0.0, 0.1), (0.1, 0.5), (0.5, 1.0), (1.0, 3.0), (3.0, 'inf') ] %>
                {
                    "title": "<< code1 >> - << code2 >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "hperc(unistat-nginx_request_total_time_hgram, << code1 >>, << code2 >>)",
                },
                <% endfor %>
            ],
        },

        <#
        # << service >> metrics
        #>
        {
            "type": "text",
            "text": "<< service >> metrics",
            << flow.coords(width=4, height = 0.3) >>,
        },
        <% for endpoint in ["conninfo", "stat"] %>
        {
            "type": "graphic",
            "title": "sharpei /<< endpoint >> response codes, rps",
            << flow.coords(width=1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for sig in list_signals(pattern='unistat-count_by_status_sharpei_' ~ endpoint ~ '_' ~ endpoint ~ '_(?P<code>\d+)_summ', itype='qloud', prj=('mail.' ~ service ~ '.' ~ env)) %>
                {
                    "title": "<<sig.sub('code')>>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "<< sig >>",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "sharpei /<< endpoint >> timings, ms",
            << flow.coords(width=1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for l, r in [ (0, 20), (20, 50), (50, 100), (100, 300), (300, 500), (500, 'inf') ] %>
                {
                    "title": "<<l>> - <<r>>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "hperc(unistat-sharpei_<< endpoint >>_time_hist_hgram, <<l>>, <<r>>)",
                },
                <% endfor %>
            ],
        },
        <% endfor %>
        <% for type in ["york", "worker"] %>
        {
            "type": "graphic",
            "title": "<< type >> error categories, rps",
            << flow.coords(width=1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for sig in list_signals(pattern='unistat-' ~ type ~ '_errors_(?P<category>\d+)_summ', itype='qloud', prj=('mail.' ~ service ~ '.' ~ env)) %>
                {
                    "title": "<< sig.sub('category') >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "<< sig >>",
                },
                <% endfor %>
            ],
        },
        <% endfor %>

        <#
        # << service >> handlers
        #>
        {
            "type": "text",
            "text": "<< service >> handlers",
            << flow.coords(width=4, height = 0.3) >>,
        },
        <% for handler in ['subscribe', 'unsubscribe', 'create_list', 'set_archivation_rule', 'remove_archivation_rule'] %>
        {
            "type": "graphic",
            "title": "/<< handler >> codes, rps",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code in [ '2xx', '3xx', '4xx', '5xx' ] %>
                {
                    "title": "<< code >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "unistat-nginx_request_<< handler >>_<< code >>_deee",
                },
                <% endfor %>
            ],
        },
        {
            "type": "graphic",
            "title": "/<< handler >> timings perc, sec",
            << flow.coords(width = 1, height = 1) >>,
            "stacked": true,
            "normalize": true,
            "signals": [
                <% for code1, code2 in [ (0.0, 0.1), (0.1, 0.5), (0.5, 1.0), (1.0, 3.0), (3.0, 'inf') ] %>
                {
                    "title": "<< code1 >> - << code2 >>",
                    "host": "<< host >>",
                    "tag": "itype=qloud;prj=mail.<< service >>.<< env >>",
                    "name": "hperc(unistat-nginx_request_time_<< handler >>_hgram, << code1 >>, << code2 >>)",
                },
                <% endfor %>
            ],
        },
        <% endfor %>
    ]
}
'''


def primary_template():
    return 'york_panel', PRIMARY_PANEL_TEMPLATE
