#pragma once

#include <yplatform/module.h>
#include <yplatform/find.h>
#include <ymod_webserver/server.h>

namespace ymod_balancer_check {

class module : public yplatform::module
{
public:
    void init(const yplatform::ptree& conf)
    {
        auto webserver_name = conf.get<std::string>("webserver");
        auto endpoint = conf.get<std::string>("endpoint");
        auto path = conf.get<std::string>("path", "/balancer_check");
        auto webserver = yplatform::find<ymod_webserver::server>(webserver_name);
        webserver->bind(
            endpoint, { path }, [this, self = yplatform::shared_from(this)](auto&& stream) {
                stream->result(
                    open_ ? ymod_webserver::codes::ok : ymod_webserver::codes::service_unavailable,
                    "");
            });
        stop_delay_ = conf.get("stop_delay", stop_delay_);
    }

    void start()
    {
        open_ = true;
    }

    void stop()
    {
        open_ = false;
        std::this_thread::sleep_for(stop_delay_);
    }

private:
    std::atomic<bool> open_{ false };
    yplatform::time_traits::duration stop_delay_ = yplatform::time_traits::seconds(10);
};

}
