#ifndef _YMODBLACKBOX_AUTH_H_
#define _YMODBLACKBOX_AUTH_H_
#include <ymod_blackbox/config.h>

#include <ymod_blackbox/address.h>
#include <ymod_blackbox/options.h>
#include <ymod_blackbox/response.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <boost/lexical_cast.hpp>

namespace ymod_blackbox {

struct request
{
    inline request(void)
        : username()
        , password()
        , sid(0)
        , no_password(false)
        , load_timezone(false)
        , load_language(false)
    {
    }

    inline request(
        yplatform::task_context_ptr ctx,
        const string& user,
        const string& pass,
        const address& addr,
        const string& srv = string())
        : username(user)
        , password(pass)
        , address(addr)
        , service(srv)
        , sid(0)
        , no_password(false)
        , load_timezone(false)
        , load_language(false)
        , context(ctx)
    {
    }

    inline request(
        yplatform::task_context_ptr ctx,
        const string& suid_,
        unsigned sid_,
        const address& addr)
        : suid(suid_)
        , address(addr)
        , service(boost::lexical_cast<string>(sid_))
        , sid(sid_)
        , no_password(false)
        , load_timezone(false)
        , load_language(false)
        , context(ctx)
    {
    }

    inline request(yplatform::task_context_ptr ctx, const string& uid_, unsigned sid_)
        : uid(uid_)
        , service(boost::lexical_cast<string>(sid_))
        , sid(sid_)
        , no_password(false)
        , load_timezone(false)
        , load_language(false)
        , context(ctx)
    {
    }

    request(yplatform::task_context_ptr ctx)
        : no_password(false), load_timezone(false), load_language(false), context(ctx)
    {
    }

    string username;
    string password;
    string suid;
    string uid;

    string oauthToken;

    // tcp::socket client_;
    struct address address;

    string service;
    unsigned int sid;

    bool no_password;
    bool load_timezone;
    bool load_language;

    options_list opt_list;
    std::vector<unsigned> sids_to_check;
    yplatform::task_context_ptr context;
};

struct response
{
    inline response(void) : success(false), user_blocked(false), uid(), suid(), error(0), retries(0)
    {
    }

    bool success;
    bool user_blocked;
    string uid;
    string suid;
    string storage;
    string login;
    string email;
    string err_str;
    string err_verbose;
    int error;
    unsigned int retries;

    string karma;
    string karma_status;
    string ban_time;
    string timezone;
    string language;
    std::set<unsigned> found_sids;
    email_list_option email_list;
    string raw;
};

typedef std::map<string, int> db_host_map;
typedef yplatform::future::future<db_host_map> future_host_map;

// Deprecated facade interface for libyabbclient.
class auth
{
public:
    virtual ~auth()
    {
    }

    virtual yplatform::future::future<response> authenticate(const request& req) = 0;

    virtual future_host_map mhost_find(
        yplatform::task_context_ptr ctx,
        const string& scope,
        const string& prio) = 0;
};

}

#endif // _YMODBLACKBOX_AUTH_H_
