#ifndef _YMODBLACKBOX_CLIENT_H_
#define _YMODBLACKBOX_CLIENT_H_
#include <ymod_blackbox/config.h>

#include <ymod_blackbox/error.h>
#include <ymod_blackbox/address.h>
#include <ymod_blackbox/options.h>
#include <ymod_blackbox/response.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <boost/function.hpp>

namespace ymod_blackbox {

typedef boost::function<void(const error&, const info_response&)> info_callback;
typedef boost::function<void(const error&, const login_response&)> login_callback;
typedef boost::function<void(const error&, const session_id_response&)> session_id_callback;
typedef boost::function<void(const error&, const mhost_find_response&)> mhost_find_callback;

typedef std::map<string, int> db_host_map;
typedef yplatform::future::future<db_host_map> future_host_map;

class client
{
public:
    virtual void async_info(
        const string& uid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_info(
        yplatform::task_context_ptr ctx,
        const string& uid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_info_suid(
        const string& suid,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_info_suid(
        yplatform::task_context_ptr ctx,
        const string& suid,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_info_login(
        const string& login,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_info_login(
        yplatform::task_context_ptr ctx,
        const string& login,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_login(
        const string& login,
        const string& sid,
        const string& password,
        const address& addr,
        const login_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_login(
        yplatform::task_context_ptr ctx,
        const string& login,
        const string& sid,
        const string& password,
        const address& addr,
        const login_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_oauth(
        const string& oauth_token,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_oauth(
        yplatform::task_context_ptr ctx,
        const string& oauth_token,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_session_id(
        const string& session_id,
        const string& hostname,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_session_id(
        yplatform::task_context_ptr ctx,
        const string& session_id,
        const string& hostname,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list()) = 0;

    virtual void async_mhost_find(
        const string& scope,
        const string& prio,
        const mhost_find_callback& cb) = 0;

    virtual void async_mhost_find(
        yplatform::task_context_ptr ctx,
        const string& scope,
        const string& prio,
        const mhost_find_callback& cb) = 0;

    virtual ~client()
    {
    }
};

}

#endif // _YMODBLACKBOX_AUTH_H_
