#pragma once

#include <ymod_blackbox/options.h>
#include <yandex/blackbox/blackbox2.h>
#include <boost/optional.hpp>

namespace ymod_blackbox {

// Response data types are wrappers to libblackbox2 types and are needed
// only to keep backward compatibility.

template <typename BBType>
class bbresponse
{
public:
    bbresponse();
    bbresponse(string&& raw_response);

    const bbresponse<BBType>& operator>>(regname_option& o) const;
    const bbresponse<BBType>& operator>>(uid_option& o) const;
    const bbresponse<BBType>& operator>>(lite_uid_option& o) const;
    const bbresponse<BBType>& operator>>(pdd_user_info_option& o) const;
    const bbresponse<BBType>& operator>>(karma_info_option& o) const;
    const bbresponse<BBType>& operator>>(display_name_option& o) const;
    const bbresponse<BBType>& operator>>(login_info_option& o) const;
    const bbresponse<BBType>& operator>>(email_list_option& o) const;
    const bbresponse<BBType>& operator>>(alias_list_option& o) const;
    const bbresponse<BBType>& operator>>(oauth_info_option& o) const;
    const string& operator[](const string& field_name) const;

    // Get blackbox info message.
    const string& message() const;

    const BBType& native_response() const;

    const string& raw_response() const;

protected:
    string raw_response_;
    std::unique_ptr<BBType> native_response_;
    mutable boost::optional<bb::DBFields> db_fields_;
};

extern template class bbresponse<bb::Response>;
extern template class bbresponse<bb::LoginResp>;
extern template class bbresponse<bb::SessionResp>;

using info_response = bbresponse<bb::Response>;

class login_response : public bbresponse<bb::LoginResp>
{
public:
    enum login_status
    {
        valid,        // params are valid
        disabled,     // login disabled
        invalid,      // params invalid
        show_captcha, // show capcha
    } status;

    login_response();
    login_response(string&& source);

    using bbresponse<bb::LoginResp>::operator>>;
    const login_response& operator>>(connection_id_option& o) const;
};

class session_id_response : public bbresponse<bb::SessionResp>
{
public:
    enum session_id_status
    {
        valid,      // params are valid
        need_reset, // reset session id
        expired,    // session id expired
        no_auth,    // no auth
        disabled,   // disabled
        invalid,    // request params invalid
    } status;
    string age;   // session is age
    bool is_lite; // is session lite

    session_id_response();
    session_id_response(string&& source);

    using bbresponse<bb::SessionResp>::operator>>;
    const session_id_response& operator>>(new_session_id_option& o) const;
    const session_id_response& operator>>(auth_info_option& o) const;
    const session_id_response& operator>>(oauth_info_option& o) const;
    const session_id_response& operator>>(connection_id_option& o) const;
};

struct mhost_find_response
{
    enum mhost_status
    {
        ok,
        access_denied,
        missing_param,
        unknown_op,
        unknown_scope,
        invalid_param,
        record_not_found, // record not found in blackbox
    } status;

    string message;

    struct item
    {
        item(
            const string& hid,
            const string& hip,
            const string& hn,
            const string& db,
            const string& s,
            const string& prio,
            const string& m)
            : host_id(hid), host_ip(hip), host_name(hn), db_id(db), sid(s), priority(prio), mx(m)
        {
        }
        string host_id;
        string host_ip;
        string host_name; // host name
        string db_id;     // database identifier
        string sid;       // service id
        string priority;
        string mx; // mx field
    };

    mhost_find_response();
    mhost_find_response(string&& raw_response);
    const bb::HostResp& native_response() const;
    const string& raw_response() const;

    typedef std::vector<item> item_list;
    item_list items; // all found mail hosts

private:
    string raw_response_;
    std::unique_ptr<bb::HostResp> native_response_;
};

}
