include(find_ymod_blackbox_dependencies)

if(YMOD_BLACKBOX_INCLUDE_DIR AND YMOD_BLACKBOX_LIBRARIES)
  set(YMOD_BLACKBOX_FIND_QUIETLY TRUE)
endif()

find_path(YMOD_BLACKBOX_INCLUDE_DIR
  NAMES ymod_blackbox/client.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(YMOD_BLACKBOX_LIBRARY
  NAMES ymod_blackbox
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_ymod_blackbox_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(YMOD_BLACKBOX DEFAULT_MSG
  YMOD_BLACKBOX_INCLUDE_DIR YMOD_BLACKBOX_LIBRARY)

if(YMOD_BLACKBOX_FOUND)
  list(APPEND YMOD_BLACKBOX_INCLUDE_DIR ${YMOD_BLACKBOX_DEPENDENCY_INCLUDE_DIRS})
  set(YMOD_BLACKBOX_LIBRARIES
    "-Wl,--whole-archive ${YMOD_BLACKBOX_LIBRARY} -Wl,--no-whole-archive"
    ${YMOD_BLACKBOX_DEPENDENCY_LIBRARIES}
  )
endif()

mark_as_advanced(YMOD_BLACKBOX_INCLUDE_DIR YMOD_BLACKBOX_LIBRARIES)
