#include "client_module_impl.h"

#include <yplatform/time_traits.h>

namespace ymod_blackbox {

void client_module::init(const yplatform::ptree& xml)
{
    settings st;
    st.parse_ptree(xml);

    auto reactor = yplatform::find<yplatform::reactor, std::shared_ptr>(xml.get<string>("reactor"));
    auto http_client = std::make_shared<yhttp::cluster_client>(*reactor, st.http);
    impl_ = std::make_shared<bbclient>(*(reactor->io()), http_client, st);
    fake_context_ = boost::make_shared<yplatform::task_context>("bbclient-module-ctx");
}

void client_module::async_info(
    const string& uid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info(fake_context_, uid, addr, cb, opts, fields, attributes);
}

void client_module::async_info(
    yplatform::task_context_ptr ctx,
    const string& uid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info(ctx, uid, addr, cb, opts, fields, attributes);
}

void client_module::async_info_suid(
    const string& suid,
    const string& sid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info_suid(fake_context_, suid, sid, addr, cb, opts, fields, attributes);
}

void client_module::async_info_suid(
    yplatform::task_context_ptr ctx,
    const string& suid,
    const string& sid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info_suid(ctx, suid, sid, addr, cb, opts, fields, attributes);
}

void client_module::async_info_login(
    const string& login,
    const string& sid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info_login(fake_context_, login, sid, addr, cb, opts, fields, attributes);
}

void client_module::async_info_login(
    yplatform::task_context_ptr ctx,
    const string& login,
    const string& sid,
    const address& addr,
    const info_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_info_login(ctx, login, sid, addr, cb, opts, fields, attributes);
}

void client_module::async_login(
    const string& login,
    const string& sid,
    const string& password,
    const address& addr,
    const login_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_login(fake_context_, login, sid, password, addr, cb, opts, fields, attributes);
}

void client_module::async_login(
    yplatform::task_context_ptr ctx,
    const string& login,
    const string& sid,
    const string& password,
    const address& addr,
    const login_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_login(ctx, login, sid, password, addr, cb, opts, fields, attributes);
}

void client_module::async_oauth(
    const string& oauth_token,
    const address& addr,
    const session_id_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_oauth(fake_context_, oauth_token, addr, cb, opts, fields, attributes);
}

void client_module::async_oauth(
    yplatform::task_context_ptr ctx,
    const string& oauth_token,
    const address& addr,
    const session_id_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_oauth(ctx, oauth_token, addr, cb, opts, fields, attributes);
}

void client_module::async_session_id(
    const string& session_id,
    const string& hostname,
    const address& addr,
    const session_id_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_session_id(
        fake_context_, session_id, hostname, addr, cb, opts, fields, attributes);
}

void client_module::async_session_id(
    yplatform::task_context_ptr ctx,
    const string& session_id,
    const string& hostname,
    const address& addr,
    const session_id_callback& cb,
    const options_list& opts,
    const db_fields_list& fields,
    const attribute_list& attributes)
{
    impl_->async_session_id(ctx, session_id, hostname, addr, cb, opts, fields, attributes);
}

void client_module::async_mhost_find(
    const string& scope,
    const string& prio,
    const mhost_find_callback& cb)
{
    impl_->async_mhost_find(fake_context_, scope, prio, cb);
}

void client_module::async_mhost_find(
    yplatform::task_context_ptr ctx,
    const string& scope,
    const string& prio,
    const mhost_find_callback& cb)
{
    impl_->async_mhost_find(ctx, scope, prio, cb);
}

}
