#pragma once

#include "bbclient.h"
#include <ymod_blackbox/client.h>
#include <ymod_blackbox/error.h>
#include <yplatform/log.h>
#include <yplatform/module.h>
#include <yplatform/ptree.h>
#include <yplatform/find.h>

namespace ymod_blackbox {

class client_module
    : public client
    , public yplatform::module
{
private:
    std::shared_ptr<bbclient> impl_;
    yplatform::module_stats_ptr stats_;
    yplatform::task_context_ptr fake_context_;

public:
    void init(const yplatform::ptree& xml);

    yplatform::ptree get_stats() const
    {
        yplatform::ptree result;
        auto stats = impl_->get_stats();
        result.put("tasks_running", stats.running);
        result.put("tasks_in_queue", stats.in_queue);
        return result;
    }

public:
    void async_info(
        const string& uid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_info(
        yplatform::task_context_ptr ctx,
        const string& uid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_info_suid(
        const string& suid,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_info_suid(
        yplatform::task_context_ptr ctx,
        const string& suid,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_info_login(
        const string& login,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_info_login(
        yplatform::task_context_ptr ctx,
        const string& login,
        const string& sid,
        const address& addr,
        const info_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_login(
        const string& login,
        const string& sid,
        const string& password,
        const address& addr,
        const login_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_login(
        yplatform::task_context_ptr ctx,
        const string& login,
        const string& sid,
        const string& password,
        const address& addr,
        const login_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_oauth(
        const string& oauth_token,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_oauth(
        yplatform::task_context_ptr ctx,
        const string& oauth_token,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_session_id(
        const string& session_id,
        const string& hostname,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_session_id(
        yplatform::task_context_ptr ctx,
        const string& session_id,
        const string& hostname,
        const address& addr,
        const session_id_callback& cb,
        const options_list& opts = options_list(),
        const db_fields_list& fields = db_fields_list(),
        const attribute_list& attributes = attribute_list());

    void async_mhost_find(const string& scope, const string& prio, const mhost_find_callback& cb);

    void async_mhost_find(
        yplatform::task_context_ptr ctx,
        const string& scope,
        const string& prio,
        const mhost_find_callback& cb);
};

}
