#pragma once

#include "bbclient.h"
#include <ymod_blackbox/auth.h>
#include <ymod_blackbox/error.h>
#include <ymod_blackbox/response.h>
#include <yplatform/log.h>
#include <yplatform/find.h>
#include <yplatform/module.h>

namespace ymod_blackbox {

class auth_impl
    : public auth
    , public yplatform::module
{
private:
    std::shared_ptr<bbclient> impl_;
    std::string default_domain_;
    yplatform::module_stats_ptr stats_;
    yplatform::task_context_ptr fake_context_;

    struct req_data
    {
        req_data()
            : f_login("subscription.login."), f_suid("subscription.suid."), f_db_id("hosts.db_id.")
        {
        }
        string f_login;
        string f_suid;
        string f_db_id;
        request req;
        std::vector<string> sid_fields;
        yplatform::future::promise<response> prom;
    };
    typedef boost::shared_ptr<req_data> req_data_ptr;

public:
    void init(const yplatform::ptree& xml);

protected:
    void info_cb(const error& e, const info_response& info, const req_data_ptr& data);

    void login_cb(const error& e, const login_response& info, const req_data_ptr& data);

    void mhost_find_cb(
        yplatform::task_context_ptr ctx,
        yplatform::future::promise<db_host_map> prom,
        const error& e,
        const mhost_find_response& info);

    template <typename T>
    void auth_cb(const error& e, const bbresponse<T>& info, const req_data_ptr& data);

    yplatform::ptree get_stats() const
    {
        yplatform::ptree result;
        auto stats = impl_->get_stats();
        result.put("tasks_running", stats.running);
        result.put("tasks_in_queue", stats.in_queue);
        return result;
    }

public:
    yplatform::future::future<response> authenticate(const request& req);

    yplatform::future::future<db_host_map> mhost_find(
        yplatform::task_context_ptr ctx,
        const string& scope,
        const string& prio);
};

}
