#pragma once

#include <ymod_blackbox/config.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/ptree.h>
#include <yandex/blackbox/blackbox2.h>

namespace ymod_blackbox {

struct settings
{
    string primary_host;
    string fallback_host;
    string authtype;                // authtype (pop/imap/smtp/web/..., see bb docs for details
    unsigned max_queue_size = 1000; // max connection pool size (max parallel requests to blackbox)
    unsigned pool_size = 32;

    bool log_pa = true;

    ymod_httpclient::cluster_client::settings http;

    void parse_ptree(const yplatform::ptree& xml)
    {
        authtype = xml.get("authtype", "");
        primary_host = xml.get("url", "");
        fallback_host = xml.get("fallback_url", "");
        max_queue_size = xml.get("queue_capacity", 1000);
        pool_size = xml.get("pool_size", 32);
        log_pa = xml.get<bool>("log_pa", log_pa);
        auto http_conf = xml.get_child_optional("http");
        if (http_conf) http.parse_ptree(*http_conf);
        auto max_attempts_temp = xml.get("retries", 3) + 1;
        http.retry_policy.max_attempts =
            xml.get("http.retry_policy.max_attempts", max_attempts_temp);
        yplatform::read_ptree(http.nodes, xml, "hosts");
        if (!primary_host.empty())
        {
            http.nodes.emplace_back(primary_host);
            if (!fallback_host.empty())
            {
                http.nodes.emplace_back(fallback_host);
            }
        }
        if (http.nodes.empty())
        {
            throw std::runtime_error("Invalid url/nodes params");
        }
        for (std::size_t i = 0; i < http.nodes.size(); ++i)
        {
            if (http.nodes[i].size() && http.nodes[i].back() != '?') http.nodes[i] += "?";
        }
    }
};

}
