#include "task_queue.h"

namespace ymod_blackbox {

task_queue::task_queue(unsigned max_parallel, unsigned max_queue)
    : max_parallel_(max_parallel), max_queue_(max_queue)
{
}

bool task_queue::push(std::function<void()>&& callback)
{
    lock_t lock(mux_);
    if (running_ >= max_parallel_)
    {
        if (impl_.size() >= max_queue_) return false;
        impl_.push_back(std::move(callback));
    }
    else
    {
        ++running_;
        lock.unlock();
        execute(callback);
    }
    return true;
}

task_queue_stats task_queue::get_stats()
{
    lock_t lock(mux_);
    return task_queue_stats{ running_, static_cast<uint32_t>(impl_.size()) };
}

void task_queue::process_next()
{
    lock_t lock(mux_);
    if (impl_.empty())
    {
        --running_;
        return;
    }
    auto callback = impl_.front();
    impl_.pop_front();
    lock.unlock();

    execute(callback);
}

void task_queue::execute(const std::function<void()>& callback)
{
    // Don't catch exceptions because there is no way to handle them here.
    callback();
}

}
