#pragma once

#include <deque>
#include <functional>
#include <mutex>

namespace ymod_blackbox {

struct task_queue_stats
{
    uint32_t running;
    uint32_t in_queue;
};

class task_queue
{
    typedef std::mutex mutex_t;
    typedef std::unique_lock<mutex_t> lock_t;

public:
    task_queue(unsigned max_parallel, unsigned max_queue);
    // Throws exceptions from callbacks.
    bool push(std::function<void()>&& callback);
    // Throws exceptions from callbacks.
    void process_next();
    task_queue_stats get_stats();

private:
    void execute(const std::function<void()>& callback);

    const unsigned max_parallel_ = 0;
    const unsigned max_queue_ = 0;
    mutex_t mux_;
    uint32_t running_ = 0;
    std::deque<std::function<void()>> impl_;
};

}
