#ifndef _YMOD_CACHE_ERROR_H_
#define _YMOD_CACHE_ERROR_H_

#include <ymod_cache/config.h>
#include <yplatform/exception.h>

#include <string>

namespace ymod_cache {

class error : public yplatform::exception
{
public:
    inline error () : yplatform::exception () {}

    explicit inline error (const string& cl)
        : yplatform::exception (cl, string (), string ())
    { }

    inline error (const string& cl, string const& pub)
        : yplatform::exception (cl, pub, string ())
    { }

    inline error (const string& cl, string const& pub, string const& prv)
        : yplatform::exception (cl, pub, prv)
    { }

    virtual inline ~error () {}
};

struct not_stored :
    YPLATFORM_ERROR_DEF(not_stored, error, "ymod_cache::not_stored", "value not stored");

struct backend_error :
    YPLATFORM_ERROR_DEF(backend_error, error, "ymod_cache::backend_error", "backend error");

struct internal_error :
    YPLATFORM_ERROR_DEF(internal_error, error, "ymod_cache::internal_error", "internal error");

class error_code
{
public:
    enum code
    {
        none = 0,
        connect_error,
        write_request_error,
        read_header_error,
        read_extras_error,
        read_key_error,
        read_value_error,
        get_session_error
    };

    error_code(code value) : _value(value) {}

    bool operator ==(code other) const { return _value == other; }
    bool operator !=(code other) const { return !operator ==(other); }
    bool operator ==(error_code other) const { return _value == other._value; }
    bool operator !=(error_code other) const { return !operator ==(other); }

    string message() const
    {
        switch (_value) {
#define ERROR_CODE(name) case name: return #name;
            ERROR_CODE(none)
            ERROR_CODE(connect_error)
            ERROR_CODE(write_request_error)
            ERROR_CODE(read_header_error)
            ERROR_CODE(read_extras_error)
            ERROR_CODE(read_key_error)
            ERROR_CODE(read_value_error)
            ERROR_CODE(get_session_error)
#undef ERROR_CODE
            default:
                return "unknown error";
        }
    }

    code value() const { return _value; }

private:
    code _value;
};

namespace memcached {

struct key_overflow :
    YPLATFORM_ERROR_DEF(key_overflow, error, "ymod_cache::memcached::key_overflow", "key is too long");

struct value_overflow :
    YPLATFORM_ERROR_DEF(value_overflow, error, "ymod_cache::memcached::value_overflow", "value is too long");

}}

#endif // _YMOD_CACHE_ERROR_H_
