include(find_ymod_cache_dependencies)

if(YMOD_CACHE_INCLUDE_DIR AND YMOD_CACHE_LIBRARIES)
  set(YMOD_CACHE_FIND_QUIETLY TRUE)
endif()

find_path(YMOD_CACHE_INCLUDE_DIR
  NAMES ymod_cache/cache.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(YMOD_CACHE_LIBRARY
  NAMES ymod_cache
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_ymod_cache_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(YMOD_CACHE DEFAULT_MSG
  YMOD_CACHE_INCLUDE_DIR YMOD_CACHE_LIBRARY)

if(YMOD_CACHE_FOUND)
  list(APPEND YMOD_CACHE_INCLUDE_DIR ${YMOD_CACHE_DEPENDENCY_INCLUDE_DIRS})
  set(YMOD_CACHE_LIBRARIES
    "-Wl,--whole-archive ${YMOD_CACHE_LIBRARY} -Wl,--no-whole-archive"
    ${YMOD_CACHE_DEPENDENCY_LIBRARIES}
  )
endif()

mark_as_advanced(YMOD_CACHE_INCLUDE_DIR YMOD_CACHE_LIBRARIES)
