#include "common.h"

#include <cstring>

namespace ymod_cache {

void collect_segment(const segment& seg, void* buffer)
{
    typedef yplatform::zerocopy::const_base_chunk::byte_t byte_t;
    size_t offset = 0;
    for (auto it = seg.begin_fragment(); it != seg.end_fragment(); ++it)
    {
        const byte_t* begin = it == seg.begin_fragment() ? seg.head() : (*it)->buff().first;
        const byte_t* end = it+1 == seg.end_fragment() ? seg.tail() : (*it)->buff().first + (*it)->buff().second;
        size_t frag_size = end-begin;
        memcpy(reinterpret_cast<byte_t*>(buffer)+offset, begin, frag_size);
        offset += frag_size;
    }
}

std::ostream& operator<<(std::ostream& stream, const segment& seg)
{
    typedef yplatform::zerocopy::const_base_chunk::byte_t byte_t;
    for (auto it = seg.begin_fragment(); it != seg.end_fragment(); ++it)
    {
        const byte_t* begin = it == seg.begin_fragment() ? seg.head() : (*it)->buff().first;
        const byte_t* end = it+1 == seg.end_fragment() ? seg.tail() : (*it)->buff().first + (*it)->buff().second;
        size_t frag_size = end-begin;
        stream.write(begin, frag_size);
    }
    return stream;
}

void impl_base::init(const yplatform::ptree& xml)
{
    // Read global settings
    value_ttl_ = xml.get("value_ttl", 0);
}

void impl_base::fini()
{
}

}
