#ifndef _YMOD_CACHE_COMMON_H_
#define _YMOD_CACHE_COMMON_H_

#include <ymod_cache/cache.h>

#include <yplatform/exception.h>

#include <ostream>

namespace ymod_cache {

typedef yplatform::future::promise<segment_result> promise_segment;
typedef yplatform::future::promise<void_result> promise_result;
typedef yplatform::future::promise<bool_result> promise_bool;

template <class Promise>
inline void deadline_hook(Promise out)
{
    out.set_exception(yplatform::deadline_error());
}

void collect_segment(const segment& seg, void* buffer);
std::ostream& operator<<(std::ostream& stream, const segment& seg);

class impl_base : public cache
{
public:
    void init(const yplatform::ptree& xml);
    void fini();

protected:

    unsigned value_ttl_;
};

}

#endif // _YMOD_CACHE_COMMON_H_
