#ifndef _YMOD_CACHE_LOCAL_CACHE_IMPL_H_
#define _YMOD_CACHE_LOCAL_CACHE_IMPL_H_

#include "common.h"

#include <boost/multi_index_container.hpp>
#include <boost/multi_index/sequenced_index.hpp>
#include <boost/multi_index/hashed_index.hpp>
#include <boost/multi_index/member.hpp>
#include <boost/thread/shared_mutex.hpp>
#include <boost/chrono.hpp>

namespace ymod_cache {
namespace local_cache {

using namespace boost::multi_index;

class impl : public impl_base
{
public:
    typedef yplatform::module_stats_ptr module_stats_ptr;

    void init(const yplatform::ptree& xml);
    void fini();

    future_result set(
        yplatform::task_context_ptr ctx,
        const segment& key,
        const segment& value);

    future_segment get(
        yplatform::task_context_ptr ctx,
        const segment& key);

    future_bool has(
        yplatform::task_context_ptr ctx,
        const segment& key);

    future_result remove(
        yplatform::task_context_ptr ctx,
        const segment& key);

    virtual const module_stats_ptr get_module_stats() const;

private:
    typedef segment key_t;
    typedef segment value_t;
    typedef boost::chrono::steady_clock::time_point time_point;

    struct entry
    {
        key_t key;
        value_t value;
        time_point expiry;
        entry(const key_t& key_, const value_t& value_, const time_point& expiry_)
            : key(key_)
            , value(value_)
            , expiry(expiry_)
        {}
    };

    struct key_tag {};

    // This definition relies on constant ttl values
    typedef multi_index_container<
        entry,
        indexed_by< // order is important
            sequenced<>,
            hashed_unique<tag<key_tag>, member<entry, key_t, &entry::key> >
        >
    > container_t;

    typedef boost::shared_mutex mutex_t;

    mutable mutex_t mux_;
    container_t cont_;
    size_t max_size_;
    bool lazy_clean_;
};

class impl_stats : public yplatform::module_stats
{
public:
    typedef yplatform::module_stats base;

    impl_stats(const size_t size) : size_(size) {}

private:
    const size_t size_;

    virtual ptree_ptr core_get_stat() const;
};

}}

#endif // _YMOD_CACHE_LOCAL_CACHE_IMPL_H_
