#pragma once

#include <ymod_cache/config.h>
#include <ymod_cache/error.h>

#include <stdint.h> // wanted by next
#include <libmemcached/memcached/protocol_binary.h>

#include <boost/shared_ptr.hpp>
#include <boost/shared_array.hpp>
#include <boost/optional.hpp>

namespace ymod_cache {
namespace memcached {

struct request
{
    union
    {
        protocol_binary_request_no_extras generic;
        protocol_binary_request_set set;
        protocol_binary_request_get get;
        protocol_binary_request_delete delete_;
    } variant;
    segment key;
    segment value;

    static
    size_t header_length();
    uint8_t* header_raw();
    size_t extras_length() const;
    uint8_t* extras_raw();

    void host_2_network_header();
    void host_2_network_extras();
    //void network_2_host_header();
    //void network_2_host_extras();
};

typedef boost::shared_ptr<request> request_ptr;

struct response
{
    union
    {
        protocol_binary_response_no_extras generic;
        protocol_binary_response_set set;
        protocol_binary_response_get get;
        protocol_binary_response_delete delete_;
    } variant;
    segment key;
    segment value;

    static
    size_t header_length();
    uint8_t* header_raw();
    size_t extras_length() const;
    uint8_t* extras_raw();

    //void host_2_network_header();
    //void host_2_network_extras();
    void network_2_host_header();
    void network_2_host_extras();
};

typedef boost::shared_ptr<response> response_ptr;

request_ptr new_request(
    protocol_binary_command cmd,
    const boost::optional<const segment&> key,
    const boost::optional<const segment&> value);

}}

