#ifndef _YMOD_CACHE_MEMCACHED_SESSION_H_
#define _YMOD_CACHE_MEMCACHED_SESSION_H_

#include <ymod_cache/config.h>
#include <ymod_cache/cache.h>

#include "protocol.h"

#include <yplatform/net/client_session_strand.h>
#include <yplatform/net/filter.h>
#include <yplatform/future/future.hpp>

#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>

#include <vector>

namespace ymod_cache {
namespace memcached {

typedef result<response_ptr> response_result;

typedef yplatform::future::future<response_result> future_response;
typedef yplatform::future::promise<response_result> promise_response;

class session
    : public yplatform::net::client_session_strand<
        yplatform::net::client_settings,
        boost::asio::ip::tcp>
    , public boost::enable_shared_from_this<session>
{
public:
    typedef
        yplatform::net::client_session_strand<
            yplatform::net::client_settings,
            boost::asio::ip::tcp
        > base_t;
    typedef yplatform::zerocopy::streambuf buffer_t;
    typedef boost::shared_ptr<buffer_t> buffer_ptr;

    session(
        yplatform::net::base_service* service,
        const yplatform::net::client_settings& settings);
    virtual ~session();

    yplatform::task_context_ptr get_context() const
    {
        return context_;
    }

    void set_context(yplatform::task_context_ptr context)
    {
        context_ = context;
    }

    void set_server(const string& address, unsigned short port);
    future_response run(const request_ptr& req);
    bool is_new() const { return is_new_; }
    void is_new(bool value) { is_new_ = value; }

    buffer_ptr create_buffer()
    { return boost::make_shared<buffer_t>(); }

private:
    void handle_timeout(const char* operation);
    void handle_connect(const boost::system::error_code& err, const request_ptr& req, promise_response out);
    void handle_write_request(const boost::system::error_code& err, const request_ptr&, promise_response out);
    void handle_read_header(const boost::system::error_code& err, std::size_t bytes, promise_response out);
    void handle_read_extras(const boost::system::error_code& err, std::size_t bytes, response_ptr res, promise_response out);
    void handle_read_key(const boost::system::error_code& err, std::size_t bytes, response_ptr res, promise_response out);
    void handle_read_value(const boost::system::error_code& err, std::size_t bytes, response_ptr res, promise_response out);

private:
    string address_;
    unsigned short port_;
    yplatform::task_context_ptr context_;
    buffer_ptr read_buff_;
    bool is_new_;
};

typedef boost::shared_ptr<session> session_ptr;

}}

#endif // _YMOD_CACHE_MEMCACHED_SESSION_H_
