#ifndef _SIMPLE_MAPPER_H_
#define _SIMPLE_MAPPER_H_

#include "mapper.h"

#include <set>
#include <cassert>

template <class In, class Out>
class simple_mapper : public mapper<In, Out>
{
    typedef mapper<In, Out> base_t;
public:
    explicit
    simple_mapper(Out min, Out max)
        : base_t(min, max)
    {
        fill_set();
    }

    void set_output_range(Out min, Out max)
    {
        update_set(min, max);
        base_t::set_output_range(min, max);
    }

private:

    void core_mask(Out out)
    {
        valid_.erase(out);
    }

    void core_unmask(Out out)
    {
        valid_.insert(out);
    }

    bool core_masked(Out out) const
    {
        return valid_.find(out) == valid_.end();
    }

    bool core_all_masked() const
    {
        return valid_.empty();
    }

    Out core_map(In in) const
    {
        typename std::set<Out>::iterator out_i = valid_.lower_bound((in % (max_-min_+1)) + min_);
        return out_i != valid_.end() ? *out_i : *valid_.lower_bound(min_);
    }

    void fill_set()
    {
        for (Out i = min_; i <= max_; ++i)
            valid_.insert(i);
    }
    void update_set(Out new_min, Out new_max)
    {
        for (Out i = new_min; i < min_; ++i)
            valid_.insert(i);
        for (Out i = min_; i < new_min; ++i)
            valid_.erase(i);
        for (Out i = max_+1; i <= new_max; ++i)
            valid_.insert(i);
        for (Out i = new_max+1; i <= max_; ++i)
            valid_.erase(i);
    }

    using base_t::min_;
    using base_t::max_;
    std::set<Out> valid_;
};

#endif // _SIMPLE_MAPPER_H_
