#ifndef _TINYINT_H_
#define _TINYINT_H_

template <int MIN, int MAX>
class tinyint
{
public:
    tinyint()
        : x(MIN)
    {}

    template <class Y>
    tinyint(Y y)
    {
        if (y < MIN)
            x = MIN;
        else if (y > MAX)
            x = MAX;
        else
            x = y;
    }

    tinyint(const tinyint<MIN, MAX>& other)
        : x(other.x)
    {}

    template <int MIN_Y, int MAX_Y>
    tinyint(const tinyint<MIN_Y, MAX_Y>& other)
    {
        if (other.x < MIN)
            x = MIN;
        else if (other.x > MAX)
            x = MAX;
        else
            x = other.x;
    }

    tinyint<MIN, MAX>& operator=(tinyint<MIN, MAX> rhs)
    {
        x = rhs.x;
        return *this;
    }

    template <int MIN_Y, int MAX_Y>
    tinyint<MIN, MAX>& operator=(tinyint<MIN_Y, MAX_Y> rhs)
    {
        return *this = tinyint<MIN, MAX>(rhs.x);
    }

    operator int() const
    {
        return x;
    }

    friend std::ostream& operator<<(std::ostream& s, tinyint<MIN, MAX> x)
    {
        return s << x.x;
    }

#define BINOP(op, opname) \
    friend tinyint<MIN, MAX> opname(tinyint<MIN, MAX> lhs, tinyint<MIN, MAX> rhs) \
    { \
        return tinyint<MIN, MAX>(lhs.x op rhs.x); \
    } \
    template <class T> \
    friend tinyint<MIN, MAX> opname(tinyint<MIN, MAX> lhs, T rhs) \
    { \
        return tinyint<MIN, MAX>(lhs.x op rhs); \
    } \
    template <class T> \
    friend tinyint<MIN, MAX> opname(T lhs, tinyint<MIN, MAX> rhs) \
    { \
        return tinyint<MIN, MAX>(lhs op rhs.x); \
    } \

#define ASSIGNOP(op, opname, implop) \
    template <class T> \
    friend tinyint<MIN, MAX>& opname(tinyint<MIN, MAX>& lhs, T rhs) \
    { \
        return lhs = lhs.x op rhs; \
    } \

    BINOP(+, operator+)
    BINOP(-, operator-)
    BINOP(*, operator*)
    BINOP(/, operator/)
    ASSIGNOP(+=, operator+=, +)
    ASSIGNOP(-=, operator-=, -)
    ASSIGNOP(*=, operator*=, *)
    ASSIGNOP(/=, operator/=, /)

    tinyint<MIN, MAX> operator++(int)
    {
        tinyint<MIN, MAX> tmp(x);
        x = x < MAX ? x+1 : x;
        return x;
    }
    tinyint<MIN, MAX>& operator++()
    {
        x = x < MAX ? x+1 : x;
        return *this;
    }

    tinyint<MIN, MAX> operator--(int)
    {
        tinyint<MIN, MAX> tmp(x);
        x = x > MIN ? x-1 : x;
        return x;
    }
    tinyint<MIN, MAX>& operator--()
    {
        x = x > MIN ? x-1 : x;
        return *this;
    }

private:
    int x;
};

namespace std {
template <int MIN, int MAX>
struct numeric_limits<tinyint<MIN, MAX> > : public numeric_limits<int>
{
    static int min() noexcept
    { return MIN; }
    static int max() noexcept
    { return MAX; }
};
}

namespace boost {
    template <int MIN, int MAX>
    struct make_unsigned<tinyint<MIN, MAX> >
    {
        typedef tinyint<MIN, MAX> type;
    };
}

#undef BINOP
#undef ASSIGNOP

#endif // _TINYINT_H_
