#include <mail/ymod_cachedb/include/error.h>

namespace ymod_cachedb {

const CacheCategory& getCacheCategory() {
    static CacheCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(CacheResult e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getCacheCategory());
}

mail_errors::error_code make_error(CacheResult e, const std::string& what) {
    return mail_errors::error_code(e, what);
}

}
