#pragma once

#include <io_result/io_result.h>
#include <mail/ymod_cachedb/include/types.h>


namespace ymod_cachedb {

struct Cache {
    virtual ~Cache() { }

    template<class Context = io_result::sync_context>
    auto get(Uid uid, Key key, RequestId reqId, Context ctx = io_result::use_sync) const {
        io_result::detail::init_async_result<Context, io_result::Hook<OptValue>> init{ctx};
        getAsync(uid, key, defaultDataType(), reqId, init.handler);
        return init.result.get();
    }

    template<class Context = io_result::sync_context>
    auto get(Uid uid, Key key, DataType dataType, RequestId reqId, Context ctx = io_result::use_sync) const {
        io_result::detail::init_async_result<Context, io_result::Hook<OptValue>> init{ctx};
        getAsync(uid, key, dataType, reqId, init.handler);
        return init.result.get();
    }

    template<class Context = io_result::sync_context>
    auto put(Uid uid, Key key, ymod_cachedb::Value value, RequestId reqId, Context ctx = io_result::use_sync) const {
        io_result::detail::init_async_result<Context, io_result::Hook<bool>> init{ctx};
        putAsync(uid, key, defaultDataType(), std::move(value), reqId, init.handler);
        return init.result.get();
    }

    template<class Context = io_result::sync_context>
    auto put(Uid uid, Key key, DataType dataType, ymod_cachedb::Value value, RequestId reqId, Context ctx = io_result::use_sync) const {
        io_result::detail::init_async_result<Context, io_result::Hook<bool>> init{ctx};
        putAsync(uid, key, dataType, std::move(value), reqId, init.handler);
        return init.result.get();
    }

protected:
    virtual void getAsync(Uid uid, Key key, DataType dataType, RequestId reqId, CallbackGet cb) const = 0;
    virtual void putAsync(Uid uid, Key key, DataType dataType, Value value, RequestId reqId, CallbackPut cb) const = 0;
    virtual DataType defaultDataType() const = 0;
};

using CachePtr = std::shared_ptr<Cache>;

}
