#pragma once

#include <mail_errors/error_code.h>


namespace ymod_cachedb {

enum class CacheResult {
    ok = 0,
    internalError
};

struct CacheCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "ymod_cachedb::Cache";
    }

    std::string message(int v) const override {
        switch(CacheResult(v)) {
            case CacheResult::ok:
                return "no error";
            case CacheResult::internalError:
                return "internal error";
        }
        return "unknown error";
    }
};

const CacheCategory& getCacheCategory();
mail_errors::error_code::base_type make_error_code(CacheResult e);
mail_errors::error_code make_error(CacheResult e, const std::string& what);

}

namespace boost::system {
template <>
struct is_error_code_enum<ymod_cachedb::CacheResult>: std::true_type { };
}


