#pragma once

#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/ymod_cachedb/include/cache.h>
#include <mail/webmail/commondb/include/logger.h>

namespace ymod_cachedb {

namespace log {
using namespace ::logdog::attr;
using namespace ::commondb::attr;
LOGDOG_DEFINE_ATTRIBUTE(std::string, dummy_settings)
constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-cachedb-tskv-log"));
}

inline auto getYplatformBackend(const std::string& name) {
    return std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, name);
}

inline auto getModuleLogger(const std::string& name) {
    auto logger = getYplatformBackend(name);
    return ::logdog::make_log(log::formatter, logger);
}
using ModuleLogger = decltype(getModuleLogger(""));

inline auto getContextLogger(const std::string& name, Uid uid, RequestId requestId) {
    auto logger = ::logdog::make_log(log::formatter, getYplatformBackend(name));
    return ::logdog::bind(logger, log::uid=std::to_string(uid), log::x_request_id=requestId.t.data());
}
using ContextLogger = decltype(getContextLogger("", Uid(), RequestId()));

using commondb::pggLogger;
using commondb::pggProfiler;


}
